/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.SessionTypeFilter;

public class JavaBuiltinSessionSerializer
implements JavaSessionSerializer {
    @Override
    public <T> void serialize(Class<T> type, T value, OutputStream outputStream, SessionTypeFilter typeFilter) throws IOException {
        try (TypeFilteringObjectOutputStream objectOutputStream = new TypeFilteringObjectOutputStream(outputStream, typeFilter);){
            objectOutputStream.writeObject(value);
        }
    }

    @Override
    public <T> T deserialize(Class<T> type, InputStream in, SessionTypeFilter typeFilter) throws IOException, ClassNotFoundException {
        try (TypeFilteringObjectInputStream objectInputStream = new TypeFilteringObjectInputStream(in, typeFilter);){
            Object value = objectInputStream.readObject();
            if (type.isInstance(value)) {
                T t = type.cast(value);
                return t;
            }
            throw new ClassCastException("Expected to read object of type " + type.getName() + " from string, but got: " + value.getClass().getName());
        }
    }

    private static final class TypeFilteringObjectInputStream
    extends ObjectInputStream {
        private final SessionTypeFilter typeFilter;

        public TypeFilteringObjectInputStream(InputStream in, SessionTypeFilter typeFilter) throws IOException {
            super(in);
            this.typeFilter = typeFilter;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            this.typeFilter.assertAllowed(desc.getName());
            return super.resolveClass(desc);
        }
    }

    private static final class TypeFilteringObjectOutputStream
    extends ObjectOutputStream {
        private final SessionTypeFilter typeFilter;

        public TypeFilteringObjectOutputStream(OutputStream out, SessionTypeFilter typeFilter) throws IOException {
            super(out);
            this.typeFilter = typeFilter;
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            this.typeFilter.assertAllowed(desc.getName());
            super.writeClassDescriptor(desc);
        }
    }
}

