/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.handling.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.Map;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.Promise;
import ratpack.exec.internal.DefaultExecController;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.impose.Impositions;
import ratpack.path.PathBinding;
import ratpack.path.internal.DefaultPathBinding;
import ratpack.path.internal.PathBindingStorage;
import ratpack.path.internal.RootPathBinding;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.RequestBodyReader;
import ratpack.server.internal.ServerRegistry;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;
import ratpack.test.handling.HandlerTimeoutException;
import ratpack.test.handling.HandlingResult;
import ratpack.test.handling.RequestFixture;
import ratpack.test.handling.internal.DefaultHandlingResult;
import ratpack.util.Exceptions;

public class DefaultRequestFixture
implements RequestFixture {
    private final ByteBuf requestBody = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer());
    private final MutableHeaders requestHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
    private final NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
    private String method = "GET";
    private String protocol = "HTTP/1.1";
    private String uri = "/";
    private HostAndPort remoteHostAndPort = HostAndPort.fromParts((String)"localhost", (int)45678);
    private HostAndPort localHostAndPort = HostAndPort.fromParts((String)"localhost", (int)5050);
    private int timeout = 5;
    private RegistryBuilder registryBuilder = Registry.builder();
    private ServerConfigBuilder serverConfigBuilder = ServerConfig.builder();
    private DefaultPathBinding pathBinding;

    @Override
    public RequestFixture body(byte[] bytes, String contentType) {
        this.requestHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        this.requestHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        this.requestBody.capacity(bytes.length).writeBytes(bytes);
        return this;
    }

    @Override
    public RequestFixture body(String text, String contentType) {
        return this.body(text.getBytes(CharsetUtil.UTF_8), contentType);
    }

    @Override
    public RegistrySpec getRegistry() {
        return this.registryBuilder;
    }

    @Override
    public HandlingResult handle(Handler handler) throws HandlerTimeoutException {
        DefaultHandlingResult.ResultsHolder results = new DefaultHandlingResult.ResultsHolder();
        return this.invoke(handler, this.getEffectiveRegistry(results), results);
    }

    @Override
    public HandlingResult handleChain(Action<? super Chain> chainAction) throws Exception {
        DefaultHandlingResult.ResultsHolder results = new DefaultHandlingResult.ResultsHolder();
        Registry registry = this.getEffectiveRegistry(results);
        ServerConfig serverConfig = (ServerConfig)registry.get(ServerConfig.class);
        Handler handler = Handlers.chain((ServerConfig)serverConfig, (Registry)registry, chainAction);
        return this.invoke(handler, registry, results);
    }

    private HandlingResult invoke(Handler handler, Registry registry, DefaultHandlingResult.ResultsHolder results) throws HandlerTimeoutException {
        ServerConfig serverConfig = (ServerConfig)registry.get(ServerConfig.class);
        DefaultRequest request = new DefaultRequest(Instant.now(), (Headers)this.requestHeaders, HttpMethod.valueOf((String)this.method.toUpperCase()), HttpVersion.valueOf((String)this.protocol), this.uri, new InetSocketAddress(this.remoteHostAndPort.getHostText(), this.remoteHostAndPort.getPort()), new InetSocketAddress(this.localHostAndPort.getHostText(), this.localHostAndPort.getPort()), serverConfig, new RequestBodyReader(){

            public long getContentLength() {
                return DefaultRequestFixture.this.requestBody.readableBytes();
            }

            public Promise<? extends ByteBuf> read(long maxContentLength, Block onTooLarge) {
                return Promise.value((Object)DefaultRequestFixture.this.requestBody).route(r -> (long)r.readableBytes() > maxContentLength, onTooLarge.action());
            }

            public TransformablePublisher<? extends ByteBuf> readStream(long maxContentLength) {
                return Streams.yield(r -> {
                    if (r.getRequestNum() > 0L) {
                        return null;
                    }
                    return DefaultRequestFixture.this.requestBody;
                });
            }
        });
        if (this.pathBinding != null) {
            handler = Handlers.chain((Handler[])new Handler[]{ctx -> {
                ((PathBindingStorage)ctx.getExecution().get(PathBindingStorage.TYPE)).push((Object)this.pathBinding);
                ctx.next();
            }, handler});
        }
        try {
            DefaultHandlingResult defaultHandlingResult = new DefaultHandlingResult(request, results, (MutableHeaders)this.responseHeaders, registry, this.timeout, handler);
            return defaultHandlingResult;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        finally {
            ((ExecController)registry.get(ExecController.class)).close();
        }
    }

    @Override
    public RequestFixture header(CharSequence name, String value) {
        this.requestHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public RequestFixture serverConfig(Action<? super ServerConfigBuilder> action) throws Exception {
        this.serverConfigBuilder = ServerConfig.builder();
        action.execute((Object)this.serverConfigBuilder);
        return this;
    }

    @Override
    public RequestFixture method(String method) {
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        this.method = method.toUpperCase();
        return this;
    }

    @Override
    public RequestFixture pathBinding(Map<String, String> pathTokens) {
        return this.pathBinding("", "", pathTokens);
    }

    @Override
    public RequestFixture pathBinding(String boundTo, String pastBinding, Map<String, String> pathTokens) {
        this.pathBinding = new DefaultPathBinding(pastBinding, ImmutableMap.copyOf(pathTokens), (PathBinding)new RootPathBinding(pastBinding));
        return this;
    }

    @Override
    public RequestFixture registry(Action<? super RegistrySpec> action) throws Exception {
        action.execute((Object)this.registryBuilder);
        return this;
    }

    @Override
    public RequestFixture responseHeader(CharSequence name, String value) {
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public RequestFixture timeout(int timeoutSeconds) {
        if (timeoutSeconds < 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this.timeout = timeoutSeconds;
        return this;
    }

    @Override
    public RequestFixture uri(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        this.uri = uri;
        return this;
    }

    @Override
    public RequestFixture remoteAddress(HostAndPort remote) {
        this.remoteHostAndPort = remote;
        return this;
    }

    @Override
    public RequestFixture localAddress(HostAndPort local) {
        this.localHostAndPort = local;
        return this;
    }

    @Override
    public RequestFixture protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    private Registry getEffectiveRegistry(DefaultHandlingResult.ResultsHolder results) {
        ClientErrorHandler clientErrorHandler = (context, statusCode) -> {
            results.setClientError(statusCode);
            context.getResponse().status(statusCode);
            results.getLatch().countDown();
        };
        ServerErrorHandler serverErrorHandler = (context, throwable1) -> {
            results.setThrowable(throwable1);
            results.getLatch().countDown();
        };
        Registry userRegistry = Registry.builder().add(ClientErrorHandler.class, (Object)clientErrorHandler).add(ServerErrorHandler.class, (Object)serverErrorHandler).build();
        return (Registry)Exceptions.uncheck(() -> {
            ServerConfig serverConfig = this.serverConfigBuilder.build();
            DefaultExecController execController = new DefaultExecController(serverConfig.getThreads());
            return ServerRegistry.serverRegistry((RatpackServer)new TestServer(), (Impositions)Impositions.none(), (ExecControllerInternal)execController, (ServerConfig)serverConfig, r -> userRegistry.join(this.registryBuilder.build()));
        });
    }

    private static class TestServer
    implements RatpackServer {
        private TestServer() {
        }

        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        public int getBindPort() {
            throw new UnsupportedOperationException();
        }

        public String getBindHost() {
            throw new UnsupportedOperationException();
        }

        public boolean isRunning() {
            throw new UnsupportedOperationException();
        }

        public void start() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void stop() throws Exception {
            throw new UnsupportedOperationException();
        }

        public RatpackServer reload() throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

