/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.embed.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import ratpack.test.embed.internal.PathEphemeralBaseDir;
import ratpack.util.Exceptions;

public class JarFileEphemeralBaseDir
extends PathEphemeralBaseDir {
    public JarFileEphemeralBaseDir(File jar) {
        super(JarFileEphemeralBaseDir.getJarPath(jar), jar.toPath());
    }

    @Override
    public Path write(String path, String content) {
        Path file = super.write(path, content);
        FileSystem fileSystem = file.getFileSystem();
        try {
            this.call("beginWrite", fileSystem);
            this.call("sync", fileSystem);
            this.call("endWrite", fileSystem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    private void call(String methodName, FileSystem fileSystem) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = fileSystem.getClass().getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)fileSystem, new Object[0]);
    }

    private static Path getJarPath(File jar) {
        FileSystem fileSystem;
        URI uri = URI.create("jar:" + jar.toURI().toString());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try {
            fileSystem = FileSystems.newFileSystem(uri, env);
        }
        catch (IOException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        return fileSystem.getPath("/", new String[0]);
    }
}

