/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test;

import java.net.URI;
import java.net.URISyntaxException;
import ratpack.func.Factory;
import ratpack.impose.ForceDevelopmentImposition;
import ratpack.impose.ForceServerListenPortImposition;
import ratpack.impose.Imposition;
import ratpack.impose.Impositions;
import ratpack.impose.ImpositionsSpec;
import ratpack.server.RatpackServer;
import ratpack.test.CloseableApplicationUnderTest;
import ratpack.util.Exceptions;

public abstract class ServerBackedApplicationUnderTest
implements CloseableApplicationUnderTest {
    private RatpackServer server;

    public static ServerBackedApplicationUnderTest of(RatpackServer ratpackServer) {
        return ServerBackedApplicationUnderTest.of((Factory<? extends RatpackServer>)Factory.constant((Object)ratpackServer));
    }

    public static ServerBackedApplicationUnderTest of(final Factory<? extends RatpackServer> ratpackServer) {
        return new ServerBackedApplicationUnderTest(){

            @Override
            protected RatpackServer createServer() throws Exception {
                return (RatpackServer)ratpackServer.create();
            }
        };
    }

    protected abstract RatpackServer createServer() throws Exception;

    protected Impositions createImpositions() throws Exception {
        return Impositions.of(i -> {
            this.addDefaultImpositions((ImpositionsSpec)i);
            this.addImpositions((ImpositionsSpec)i);
        });
    }

    protected void addDefaultImpositions(ImpositionsSpec impositionsSpec) {
        impositionsSpec.add((Imposition)ForceServerListenPortImposition.ephemeral());
        impositionsSpec.add((Imposition)ForceDevelopmentImposition.of((boolean)true));
    }

    protected void addImpositions(ImpositionsSpec impositions) {
    }

    @Override
    public URI getAddress() {
        URI address;
        if (this.server == null) {
            try {
                this.server = (RatpackServer)this.createImpositions().impose(() -> {
                    RatpackServer server = this.createServer();
                    server.start();
                    return server;
                });
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
        try {
            address = new URI(this.server.getScheme() + "://" + this.server.getBindHost() + ":" + this.server.getBindPort() + "/");
        }
        catch (URISyntaxException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        return address;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

