/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.http.internal;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ratpack.test.http.MultipartFileSpec;
import ratpack.test.http.MultipartFormSpec;

public class DefaultMultipartForm {
    private final Data data;
    private final Writer writer;
    private final Map<String, String> _headers;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultMultipartForm(Data data) {
        this.data = data;
        this.writer = new Writer(data);
        this._headers = new HashMap<String, String>();
        this._headers.put("Content-Type", this.getContentType());
    }

    public String getBody() {
        return this.writer.write();
    }

    public String getContentType() {
        return String.format("multipart/form-data; boundary=%s", this.data.boundary);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this._headers);
    }

    public static final class Encoding {
        static final List<String> VALUES = Stream.of("BASE64", "QUOTED-PRINTABLE", "8BIT", "7BIT", "BINARY").collect(Collectors.toList());

        static boolean isValid(String value) {
            return VALUES.stream().anyMatch(constant -> value.equalsIgnoreCase((String)constant) || value.toUpperCase().startsWith("X-"));
        }
    }

    public static final class File
    implements Comparable<File> {
        private final String _contentType;
        private final byte[] _data;
        private final String _encoding;
        private final String _field;
        private final String _name;

        private File(String field, String contentType, String encoding, String name, byte[] data) {
            this._contentType = contentType;
            this._data = data;
            this._encoding = encoding;
            this._field = field;
            this._name = name;
        }

        public String getContentType() {
            return this._contentType;
        }

        public byte[] getData() {
            return this._data;
        }

        public String getEncoding() {
            return this._encoding;
        }

        public String getField() {
            return this._field;
        }

        public String getName() {
            return this._name;
        }

        @Override
        public int compareTo(File file) {
            int result = this._field.compareTo(file._field);
            if (result == 0) {
                result = this._name.compareTo(file._name);
            }
            return result;
        }

        private void validate() {
            if (!(this.isValueSet(this._contentType) && this.isValueSet(this._data) && this.isValueSet(this._field) && this.isValueSet(this._name))) {
                throw new IllegalArgumentException(String.format("File requires contentType, name and data (%s, %s, %s, %s)", this._field, this._contentType, this._name, this._data));
            }
            if (this.isValueSet(this._encoding) && !Encoding.isValid(this._encoding)) {
                throw new IllegalArgumentException(String.format("Invalid content transfer encoding: [%s]", this._encoding));
            }
        }

        private boolean isValueSet(String value) {
            return value != null && !value.isEmpty();
        }

        private boolean isValueSet(byte[] value) {
            return value != null && value.length != 0;
        }
    }

    public static final class FileBuilder
    implements MultipartFileSpec {
        private final Builder _builder;
        private String _contentType;
        private byte[] _data;
        private String _encoding;
        private String _field;
        private String _name;

        private FileBuilder(Builder builder) {
            this._builder = builder;
            this._contentType = "text/plain";
            this._field = "file";
            this._name = "filename.txt";
        }

        @Override
        public Builder add() {
            File file = new File(this._field, this._contentType, this._encoding, this._name, this._data);
            file.validate();
            return this._builder.add(file);
        }

        @Override
        public FileBuilder contentType(String contentType) {
            this._contentType = contentType;
            return this;
        }

        @Override
        public FileBuilder data(byte[] data) {
            this._data = data;
            return this;
        }

        @Override
        public FileBuilder data(String data) {
            try {
                this._data = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException(uee);
            }
            return this;
        }

        @Override
        public FileBuilder encoding(String encoding) {
            this._encoding = encoding;
            return this;
        }

        @Override
        public FileBuilder field(String field) {
            this._field = field;
            return this;
        }

        @Override
        public FileBuilder name(String name) {
            this._name = name;
            return this;
        }
    }

    public static final class Builder
    implements MultipartFormSpec {
        private final String _boundary = Builder.generateBoundary();
        private final Map<String, Set<String>> _fields = new TreeMap<String, Set<String>>();
        private final Map<String, Set<File>> _files = new TreeMap<String, Set<File>>();

        private Builder() {
        }

        public String getBoundary() {
            return this._boundary;
        }

        public Map<String, Set<String>> getFields() {
            return Collections.unmodifiableMap(this._fields);
        }

        public Map<String, Set<File>> getFiles() {
            return Collections.unmodifiableMap(this._files);
        }

        public DefaultMultipartForm build() {
            return new DefaultMultipartForm(new Data(this._boundary, this._fields, this._files));
        }

        @Override
        public Builder field(String name, String value) {
            if (!this._fields.containsKey(name)) {
                this._fields.put(name, new TreeSet());
            }
            this._fields.get(name).add(value);
            return this;
        }

        public Builder fields(Map<String, String> data) {
            data.forEach(this::field);
            return this;
        }

        @Override
        public FileBuilder file() {
            return new FileBuilder(this);
        }

        private Builder add(File file) {
            String name = file.getField();
            if (!this._files.containsKey(name)) {
                this._files.put(name, new TreeSet());
            }
            this._files.get(name).add(file);
            return this;
        }

        private static String generateBoundary() {
            return String.format("TEST%d", System.currentTimeMillis());
        }
    }

    static final class Data {
        final String boundary;
        final Map<String, Set<String>> fields;
        final Map<String, Set<File>> files;

        Data(String boundary, Map<String, Set<String>> fields, Map<String, Set<File>> files) {
            this.boundary = boundary;
            this.fields = Collections.unmodifiableMap(fields);
            this.files = Collections.unmodifiableMap(files);
        }
    }

    static final class Writer {
        private final Data data;

        Writer(Data data) {
            this.data = data;
        }

        String write() {
            StringBuilder result = new StringBuilder();
            this.addFields(this.data.fields, this.data.boundary, result);
            this.addFiles(this.data.files, this.data.boundary, result);
            this.closeBoundary(this.data.boundary, result);
            return result.toString();
        }

        private void addFields(Map<String, Set<String>> fields, String boundary, StringBuilder out) {
            fields.forEach((name, values) -> values.forEach(value -> {
                this.openBoundary(boundary, out);
                this.declareField((String)name, out);
                this.data(value.getBytes(), out);
            }));
        }

        private void addFiles(Map<String, Set<File>> files, String boundary, StringBuilder out) {
            files.forEach((name, filesByField) -> {
                this.openBoundary(boundary, out);
                if (filesByField.size() > 1) {
                    this.addMultipleFilesToField((Set<File>)filesByField, (String)name, out);
                } else {
                    this.addSingleFileToField((Set<File>)filesByField, out);
                }
            });
        }

        private void addMultipleFilesToField(Set<File> files, String name, StringBuilder out) {
            String subBoundary = this.generateSubBoundary(this.data.boundary, name);
            this.declareField(name, out);
            this.type(String.format("multipart/mixed, boundary=%s\n", subBoundary), out);
            files.forEach(file -> {
                this.openBoundary(subBoundary, out);
                this.disposition(String.format("attachment; filename=\"%s\"", file.getName()), out);
                this.file((File)file, out);
            });
            this.closeBoundary(subBoundary, out);
        }

        private void addSingleFileToField(Set<File> files, StringBuilder out) {
            File file = (File)files.stream().findFirst().get();
            this.disposition(String.format("form-data; name=\"%s\"; filename=\"%s\"", file.getField(), file.getName()), out);
            this.file(file, out);
        }

        private void data(byte[] value, StringBuilder out) {
            out.append("\n");
            out.append(new String(value));
            out.append("\n");
        }

        private void declareField(String name, StringBuilder out) {
            this.disposition(String.format("form-data; name=\"%s\"", name), out);
        }

        private void disposition(String value, StringBuilder out) {
            this.label("Content-Disposition", value, out);
        }

        private void encoding(String value, StringBuilder out) {
            if (value != null && !value.isEmpty()) {
                this.label("Content-Transfer-Encoding", value, out);
            }
        }

        private void file(File file, StringBuilder out) {
            this.type(file.getContentType(), out);
            this.encoding(file.getEncoding(), out);
            this.data(file.getData(), out);
        }

        private String generateSubBoundary(String boundary, String name) {
            return String.format("%s_%s", boundary, name);
        }

        private void type(String value, StringBuilder out) {
            this.label("Content-Type", value, out);
        }

        private void label(String label, String value, StringBuilder out) {
            out.append(label);
            out.append(": ");
            out.append(value);
            out.append("\n");
        }

        private void openBoundary(String boundary, StringBuilder out) {
            out.append("--");
            out.append(boundary);
            out.append("\n");
        }

        private void closeBoundary(String boundary, StringBuilder out) {
            out.append("--");
            out.append(boundary);
            out.append("--\n");
        }
    }
}

