/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.SynchronizedQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.TrampolineScheduler;

public final class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;

    public OperatorObserveOn(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        ObserveOnSubscriber<T> parent = new ObserveOnSubscriber<T>(this.scheduler, child);
        parent.init();
        return parent;
    }

    static final class ScheduledUnsubscribe
    implements Subscription {
        final Scheduler.Worker worker;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScheduledUnsubscribe> ONCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ScheduledUnsubscribe.class, "once");
        volatile boolean unsubscribed = false;

        public ScheduledUnsubscribe(Scheduler.Worker worker) {
            this.worker = worker;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        @Override
        public void unsubscribe() {
            if (ONCE_UPDATER.getAndSet(this, 1) == 0) {
                this.worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        ScheduledUnsubscribe.this.worker.unsubscribe();
                        ScheduledUnsubscribe.this.unsubscribed = true;
                    }
                });
            }
        }
    }

    private static final class ObserveOnSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> child;
        final Scheduler.Worker recursiveScheduler;
        final ScheduledUnsubscribe scheduledUnsubscribe;
        final NotificationLite<T> on = NotificationLite.instance();
        final Queue<Object> queue;
        volatile boolean finished = false;
        volatile long requested = 0L;
        static final AtomicLongFieldUpdater<ObserveOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ObserveOnSubscriber.class, "requested");
        volatile long counter;
        static final AtomicLongFieldUpdater<ObserveOnSubscriber> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ObserveOnSubscriber.class, "counter");
        volatile Throwable error;
        final Action0 action = new Action0(){

            @Override
            public void call() {
                ObserveOnSubscriber.this.pollQueue();
            }
        };

        public ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> child) {
            this.child = child;
            this.recursiveScheduler = scheduler.createWorker();
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(RxRingBuffer.SIZE) : new SynchronizedQueue<Object>(RxRingBuffer.SIZE);
            this.scheduledUnsubscribe = new ScheduledUnsubscribe(this.recursiveScheduler);
        }

        void init() {
            this.child.add(this.scheduledUnsubscribe);
            this.child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    BackpressureUtils.getAndAddRequest(REQUESTED, ObserveOnSubscriber.this, n);
                    ObserveOnSubscriber.this.schedule();
                }
            });
            this.child.add(this.recursiveScheduler);
            this.child.add(this);
        }

        @Override
        public void onStart() {
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onNext(T t) {
            if (this.isUnsubscribed()) {
                return;
            }
            if (!this.queue.offer(this.on.next(t))) {
                this.onError(new MissingBackpressureException());
                return;
            }
            this.schedule();
        }

        @Override
        public void onCompleted() {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            this.finished = true;
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            this.error = e;
            this.unsubscribe();
            this.finished = true;
            this.schedule();
        }

        protected void schedule() {
            if (COUNTER_UPDATER.getAndIncrement(this) == 0L) {
                this.recursiveScheduler.schedule(this.action);
            }
        }

        void pollQueue() {
            int emitted = 0;
            do {
                this.counter = 1L;
                long produced = 0L;
                long r = this.requested;
                while (true) {
                    Object o;
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    if (this.finished) {
                        Throwable error = this.error;
                        if (error != null) {
                            this.queue.clear();
                            this.child.onError(error);
                            return;
                        }
                        if (this.queue.isEmpty()) {
                            this.child.onCompleted();
                            return;
                        }
                    }
                    if (r <= 0L || (o = this.queue.poll()) == null) break;
                    this.child.onNext(this.on.getValue(o));
                    --r;
                    ++emitted;
                    ++produced;
                }
                if (produced <= 0L || this.requested == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -produced);
            } while (COUNTER_UPDATER.decrementAndGet(this) > 0L);
            if (emitted > 0) {
                this.request(emitted);
            }
        }
    }
}

