/*
 * Decompiled with CFR 0.152.
 */
package io.reactors.common;

import io.reactors.common.Ref;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u0013\tia)Y:u\u0011\u0006\u001c\b\u000eV1cY\u0016T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!\u0001\u0005sK\u0006\u001cGo\u001c:t\u0015\u00059\u0011AA5p\u0007\u0001)\"A\u0003\r\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\rC\u0003\u0013\u0001\u0011\u00051#\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0019Q\u0003\u0001\f\u000e\u0003\t\u0001\"a\u0006\r\r\u0001\u0011)\u0011\u0004\u0001b\u00015\t\tQ*\u0005\u0002\u001c\u0017A\u0011A\u0002H\u0005\u0003;5\u0011AAT;mY\"Aq\u0004\u0001a\u0001\n#!\u0001%A\u0003uC\ndW-F\u0001\"!\ra!\u0005J\u0005\u0003G5\u0011Q!\u0011:sCf\u00042!F\u0013\u0017\u0013\t1#AA\u0002SK\u001aD\u0001\u0002\u000b\u0001A\u0002\u0013EA!K\u0001\ni\u0006\u0014G.Z0%KF$\"AK\u0017\u0011\u00051Y\u0013B\u0001\u0017\u000e\u0005\u0011)f.\u001b;\t\u000f9:\u0013\u0011!a\u0001C\u0005\u0019\u0001\u0010J\u0019\t\rA\u0002\u0001\u0015)\u0003\"\u0003\u0019!\u0018M\u00197fA!A!\u0007\u0001a\u0001\n#!1'\u0001\u0003tSj,W#\u0001\u001b\u0011\u00051)\u0014B\u0001\u001c\u000e\u0005\rIe\u000e\u001e\u0005\tq\u0001\u0001\r\u0011\"\u0005\u0005s\u0005A1/\u001b>f?\u0012*\u0017\u000f\u0006\u0002+u!9afNA\u0001\u0002\u0004!\u0004B\u0002\u001f\u0001A\u0003&A'A\u0003tSj,\u0007\u0005\u0003\u0005?\u0001\u0001\u0007I\u0011\u0003\u00034\u0003%!\bN]3tQ>dG\r\u0003\u0005A\u0001\u0001\u0007I\u0011\u0003\u0003B\u00035!\bN]3tQ>dGm\u0018\u0013fcR\u0011!F\u0011\u0005\b]}\n\t\u00111\u00015\u0011\u0019!\u0005\u0001)Q\u0005i\u0005QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\t\u000b\u0019\u0003A\u0011B$\u0002\u000b%tG-\u001a=\u0015\u0005QB\u0005\"B%F\u0001\u0004!\u0014!\u00015\t\u000b-\u0003A\u0011\u0002'\u0002\u001b\u0019Lg\u000eZ#oiJL\u0018*\u001c9m)\t!S\nC\u0003O\u0015\u0002\u0007a#A\u0002nkbDQ\u0001\u0015\u0001\u0005\u0002E\u000b\u0001\"\u00193e\u000b:$(/\u001f\u000b\u0003%V\u0003\"\u0001D*\n\u0005Qk!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001d>\u0003\rA\u0006\u0005\u0007/\u0002!\t\u0002\u0002-\u0002\u001bI,Wn\u001c<f\u000b:$(/_!u)\r\u0011\u0016l\u0017\u0005\u00065Z\u0003\r\u0001N\u0001\u0004S\u0012D\b\"\u0002(W\u0001\u00041\u0002\"B/\u0001\t\u0003q\u0016a\u0003:f[>4X-\u00128uef$\"AU0\t\u000b9c\u0006\u0019\u0001\f\t\u000b\u0005\u0004A\u0011\u00012\u0002\u001f%tg/\u00197jI\u0006$X-\u00128uef$\"AK2\t\u000b9\u0003\u0007\u0019\u0001\f\t\u000b\u0015\u0004A\u0011\u00024\u0002\u0013\u001d\u0014xn\u001e+bE2,G#\u0001\u0016\t\u000b!\u0004A\u0011I5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001\\1oO*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005\u0019\u0019FO]5oO\u0002")
public class FastHashTable<M> {
    private Ref<M>[] table = new Ref[4];
    private int size = 0;
    private int threshold = 4;

    public Ref<M>[] table() {
        return this.table;
    }

    public void table_$eq(Ref<M>[] x$1) {
        this.table = x$1;
    }

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    private int index(int h) {
        return h & this.table().length - 1;
    }

    /*
     * WARNING - void declaration
     */
    private Ref<M> findEntryImpl(M mux) {
        int h = this.index(mux.hashCode());
        Ref<M> entry = this.table()[h];
        Ref<M> ref;
        while (entry != null && !BoxesRunTime.equals(entry.get(), mux)) {
            void var2_2;
            var2_2 = (var2_2 + true) % this.table().length;
            ref = this.table()[var2_2];
        }
        return ref;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addEntry(M mux) {
        int h = this.index(mux.hashCode());
        Ref<M> entry = this.table()[h];
        while (true) {
            void var2_2;
            Ref<M> ref;
            if (entry == null) {
                this.table()[h] = new Ref<M>(mux);
                this.size_$eq(this.size() + 1);
                if (this.size() >= this.threshold()) {
                    this.growTable();
                }
                return true;
            }
            if (BoxesRunTime.equals(ref.get(), mux)) {
                return false;
            }
            var2_2 = (var2_2 + true) % this.table().length;
            ref = this.table()[var2_2];
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeEntryAt(int idx, M mux) {
        int h = idx;
        Ref<M> entry = this.table()[h];
        while (entry != null) {
            void var3_3;
            Ref<M> ref;
            if (BoxesRunTime.equals(ref.get(), mux)) {
                void h0 = var3_3;
                void h1 = (h0 + true) % this.table().length;
                boolean found = false;
                while (true) {
                    Object elem;
                    if (found) {
                        this.table()[h0] = null;
                        this.size_$eq(this.size() - 1);
                        return true;
                    }
                    Object object = elem = this.table()[h1] == null ? null : (Object)this.table()[h1].get();
                    if (elem == null) {
                        found = true;
                        continue;
                    }
                    int h2 = this.index(elem.hashCode());
                    if (h2 != h1 && this.precedes$1(h2, (int)h0)) {
                        this.table()[h0] = this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + true) % this.table().length;
                }
            }
            var3_3 = (var3_3 + true) % this.table().length;
            ref = this.table()[var3_3];
        }
        return false;
    }

    public boolean removeEntry(M mux) {
        int h = this.index(mux.hashCode());
        return this.removeEntryAt(h, mux);
    }

    public void invalidateEntry(M mux) {
        Ref<M> w = this.findEntryImpl(mux);
        if (w != null) {
            w.clear();
        }
    }

    private void growTable() {
        Ref<M>[] oldtable = this.table();
        this.table_$eq(new Ref[this.table().length * 2]);
        this.size_$eq(0);
        this.threshold_$eq((int)((double)this.table().length * 0.45));
        for (int i = 0; i < oldtable.length; ++i) {
            Ref<M> entry = oldtable[i];
            Object object = entry == null || entry.get() == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.addEntry(entry.get()));
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)this.getClass().getSimpleName()).append((Object)((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.table()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Ref<M> x$1) {
                return x$1 != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final M apply(Ref<M> x$2) {
                return x$2.get();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))).mkString("(", ", ", ")")).toString();
    }

    private final boolean precedes$1(int i, int j) {
        int d = this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }
}

