/*
 * Decompiled with CFR 0.152.
 */
package io.reactors.common.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u0017\taQ+\u001b3HK:,'/\u0019;pe*\u00111\u0001B\u0001\u000bG>t7-\u001e:sK:$(BA\u0003\u0007\u0003\u0019\u0019w.\\7p]*\u0011q\u0001C\u0001\te\u0016\f7\r^8sg*\t\u0011\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#A\u0006tG\u0006d\u0017MY5mSRLX#A\u000b\u0011\u000551\u0012BA\f\u000f\u0005\rIe\u000e\u001e\u0005\t3\u0001\u0011\t\u0011)A\u0005+\u0005a1oY1mC\nLG.\u001b;zA!)1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!H\u0010\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000bMQ\u0002\u0019A\u000b\t\u000f\u0005\u0002!\u0019!C\u0005)\u0005I1\r[;oWNK'0\u001a\u0005\u0007G\u0001\u0001\u000b\u0011B\u000b\u0002\u0015\rDWO\\6TSj,\u0007\u0005C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\u0002\u00175\f\u0017N\\\"pk:$XM]\u000b\u0002OA\u0011\u0001\u0006M\u0007\u0002S)\u0011!fK\u0001\u0007CR|W.[2\u000b\u0005\ra#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011'\u000b\u0002\u000b\u0003R|W.[2M_:<\u0007BB\u001a\u0001A\u0003%q%\u0001\u0007nC&t7i\\;oi\u0016\u0014\b\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u001b1|7-\u00197D_VtG/\u001a:t+\u00059\u0004C\u0001\u00159\u0013\tI\u0014FA\bBi>l\u0017n\u0019'p]\u001e\f%O]1z\u0011\u0019Y\u0004\u0001)A\u0005o\u0005qAn\\2bY\u000e{WO\u001c;feN\u0004\u0003\"B\u001f\u0001\t\u0003q\u0014\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u0003}\u0002\"!\u0004!\n\u0005\u0005s!\u0001\u0002'p]\u001e\u0004")
public class UidGenerator {
    private final int scalability;
    private final int chunkSize;
    private final AtomicLong mainCounter;
    private final AtomicLongArray localCounters;

    public int scalability() {
        return this.scalability;
    }

    private int chunkSize() {
        return this.chunkSize;
    }

    private AtomicLong mainCounter() {
        return this.mainCounter;
    }

    private AtomicLongArray localCounters() {
        return this.localCounters;
    }

    public long generate() {
        int pos = (int)Thread.currentThread().getId() % this.localCounters().length();
        return this.get$1(pos);
    }

    private final long get$1(int pos$1) {
        long v;
        while (true) {
            if ((v = this.localCounters().get(pos$1)) % (long)this.chunkSize() == 0L) {
                long newStart = this.mainCounter().getAndAdd(this.chunkSize());
                this.localCounters().compareAndSet(pos$1, v, newStart + 1L);
                continue;
            }
            if (this.localCounters().compareAndSet(pos$1, v, v + 1L)) break;
        }
        return v;
    }

    public UidGenerator(int scalability) {
        this.scalability = scalability;
        this.chunkSize = 128;
        this.mainCounter = new AtomicLong(0L);
        this.localCounters = new AtomicLongArray(scalability);
    }
}

