/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop.sync;

import io.realm.kotlin.internal.interop.CapiT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.sync.WebsocketErrorCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bR\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/realm/kotlin/internal/interop/sync/WebSocketObserver;", "", "webSocketObserverPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/CapiT;", "Lio/realm/kotlin/internal/interop/RealmWebsocketProviderPointer;", "<init>", "(Lio/realm/kotlin/internal/interop/NativePointer;)V", "onConnected", "", "protocol", "", "onError", "onNewMessage", "", "data", "", "onClose", "wasClean", "errorCode", "Lio/realm/kotlin/internal/interop/sync/WebsocketErrorCode;", "reason", "cinterop_release"})
public final class WebSocketObserver {
    @NotNull
    private final NativePointer<CapiT> webSocketObserverPointer;

    public WebSocketObserver(@NotNull NativePointer<CapiT> webSocketObserverPointer) {
        Intrinsics.checkNotNullParameter(webSocketObserverPointer, (String)"webSocketObserverPointer");
        this.webSocketObserverPointer = webSocketObserverPointer;
    }

    public final void onConnected(@NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        RealmInterop.INSTANCE.realm_sync_socket_websocket_connected(this.webSocketObserverPointer, protocol);
    }

    public final void onError() {
        RealmInterop.INSTANCE.realm_sync_socket_websocket_error(this.webSocketObserverPointer);
    }

    public final boolean onNewMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return RealmInterop.INSTANCE.realm_sync_socket_websocket_message(this.webSocketObserverPointer, data);
    }

    public final void onClose(boolean wasClean, @NotNull WebsocketErrorCode errorCode, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        RealmInterop.INSTANCE.realm_sync_socket_websocket_closed(this.webSocketObserverPointer, wasClean, errorCode, reason);
    }
}

