/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.BaseRealmImpl;
import io.realm.internal.FrozenRealmReference;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.LiveRealmReference;
import io.realm.internal.RealmImpl;
import io.realm.internal.VersionTracker;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.util.Validation;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020 H\u0014J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0014J\r\u0010&\u001a\u00020 H\u0000\u00a2\u0006\u0002\b'R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128PX\u0090\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0018\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lio/realm/internal/LiveRealm;", "Lio/realm/internal/BaseRealmImpl;", "owner", "Lio/realm/internal/RealmImpl;", "configuration", "Lio/realm/internal/InternalConfiguration;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/realm/internal/RealmImpl;Lio/realm/internal/InternalConfiguration;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_snapshot", "Lkotlinx/atomicfu/AtomicRef;", "Lio/realm/internal/FrozenRealmReference;", "getOwner", "()Lio/realm/internal/RealmImpl;", "realmChangeRegistration", "Lio/realm/internal/interop/RegistrationToken;", "J", "realmReference", "Lio/realm/internal/LiveRealmReference;", "getRealmReference$io_realm_kotlin_library", "()Lio/realm/internal/LiveRealmReference;", "realmReference$delegate", "Lkotlin/Lazy;", "schemaChangeRegistration", "snapshot", "getSnapshot$io_realm_kotlin_library", "()Lio/realm/internal/FrozenRealmReference;", "versionTracker", "Lio/realm/internal/VersionTracker;", "getVersionTracker$io_realm_kotlin_library", "()Lio/realm/internal/VersionTracker;", "close", "", "close$io_realm_kotlin_library", "onRealmChanged", "onSchemaChanged", "schema", "Lio/realm/internal/interop/NativePointer;", "unregisterCallbacks", "unregisterCallbacks$io_realm_kotlin_library", "io.realm.kotlin.library"})
public abstract class LiveRealm
extends BaseRealmImpl {
    @NotNull
    private final RealmImpl owner;
    private final long realmChangeRegistration;
    private final long schemaChangeRegistration;
    @NotNull
    private final VersionTracker versionTracker;
    @NotNull
    private final Lazy realmReference$delegate;
    @NotNull
    private final AtomicRef<FrozenRealmReference> _snapshot;

    public LiveRealm(@NotNull RealmImpl owner, @NotNull InternalConfiguration configuration, @Nullable CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration);
        this.owner = owner;
        this.versionTracker = new VersionTracker(this.owner.getLog$io_realm_kotlin_library());
        this.realmReference$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LiveRealmReference>(configuration, dispatcher, this){
            final /* synthetic */ InternalConfiguration $configuration;
            final /* synthetic */ CoroutineDispatcher $dispatcher;
            final /* synthetic */ LiveRealm this$0;
            {
                this.$configuration = $configuration;
                this.$dispatcher = $dispatcher;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LiveRealmReference invoke() {
                NativePointer dbPointer = RealmInterop.INSTANCE.realm_open(this.$configuration.getNativeConfig(), this.$dispatcher);
                return new LiveRealmReference(this.this$0, dbPointer);
            }
        }));
        this._snapshot = AtomicFU.atomic(null);
        this.realmChangeRegistration = RealmInterop.INSTANCE.realm_add_realm_changed_callback-by8XxRo(this.getRealmReference$io_realm_kotlin_library().getDbPointer(), (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((LiveRealm)this.receiver).onRealmChanged();
            }
        });
        this.schemaChangeRegistration = RealmInterop.INSTANCE.realm_add_schema_changed_callback-by8XxRo(this.getRealmReference$io_realm_kotlin_library().getDbPointer(), (Function1)new Function1<NativePointer, Unit>((Object)this){

            public final void invoke(@NotNull NativePointer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LiveRealm)this.receiver).onSchemaChanged(p0);
            }
        });
    }

    public /* synthetic */ LiveRealm(RealmImpl realmImpl, InternalConfiguration internalConfiguration, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineDispatcher = null;
        }
        this(realmImpl, internalConfiguration, coroutineDispatcher);
    }

    @NotNull
    public final RealmImpl getOwner() {
        return this.owner;
    }

    @NotNull
    public final VersionTracker getVersionTracker$io_realm_kotlin_library() {
        return this.versionTracker;
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference$io_realm_kotlin_library() {
        Lazy lazy = this.realmReference$delegate;
        return (LiveRealmReference)lazy.getValue();
    }

    @NotNull
    public final FrozenRealmReference getSnapshot$io_realm_kotlin_library() {
        if (this._snapshot.getValue() == null) {
            FrozenRealmReference snapshot = this.getRealmReference$io_realm_kotlin_library().snapshot(this.owner);
            this.versionTracker.trackAndCloseExpiredReferences(snapshot);
            this._snapshot.setValue((Object)snapshot);
        }
        FrozenRealmReference frozenRealmReference = (FrozenRealmReference)this._snapshot.getValue();
        if (frozenRealmReference == null) {
            Validation.INSTANCE.sdkError("Snapshot should never be null");
            throw new KotlinNothingValueException();
        }
        return frozenRealmReference;
    }

    protected void onRealmChanged() {
        this._snapshot.setValue(null);
    }

    protected void onSchemaChanged(@NotNull NativePointer schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.getRealmReference$io_realm_kotlin_library().refreshSchemaMetadata();
    }

    public final void unregisterCallbacks$io_realm_kotlin_library() {
        RealmInterop.INSTANCE.realm_remove_realm_changed_callback-MSUzufI(this.getRealmReference$io_realm_kotlin_library().getDbPointer(), this.realmChangeRegistration);
        RealmInterop.INSTANCE.realm_remove_schema_changed_callback-MSUzufI(this.getRealmReference$io_realm_kotlin_library().getDbPointer(), this.schemaChangeRegistration);
    }

    @Override
    public void close$io_realm_kotlin_library() {
        this.unregisterCallbacks$io_realm_kotlin_library();
        this.versionTracker.close();
        this.getRealmReference$io_realm_kotlin_library().close();
        super.close$io_realm_kotlin_library();
    }
}

