/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.FrozenRealmReference;
import io.realm.internal.RealmLog;
import io.realm.internal.RealmReference;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013R6\u0010\u0005\u001a*\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lio/realm/internal/VersionTracker;", "", "log", "Lio/realm/internal/RealmLog;", "(Lio/realm/internal/RealmLog;)V", "intermediateReferences", "Lkotlinx/atomicfu/AtomicRef;", "", "Lkotlin/Pair;", "Lio/realm/internal/interop/NativePointer;", "Ljava/lang/ref/WeakReference;", "Lio/realm/internal/RealmReference;", "Lio/realm/internal/platform/WeakReference;", "getLog", "()Lio/realm/internal/RealmLog;", "close", "", "trackAndCloseExpiredReferences", "realmReference", "Lio/realm/internal/FrozenRealmReference;", "io.realm.kotlin.library"})
public final class VersionTracker {
    @NotNull
    private final RealmLog log;
    @NotNull
    private final AtomicRef<Set<Pair<NativePointer, WeakReference<RealmReference>>>> intermediateReferences;

    public VersionTracker(@NotNull RealmLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.intermediateReferences = AtomicFU.atomic((Object)new LinkedHashSet());
    }

    @NotNull
    public final RealmLog getLog() {
        return this.log;
    }

    public final void trackAndCloseExpiredReferences(@Nullable FrozenRealmReference realmReference2) {
        Set references = new LinkedHashSet();
        FrozenRealmReference frozenRealmReference = realmReference2;
        if (frozenRealmReference != null) {
            FrozenRealmReference it = frozenRealmReference;
            boolean bl = false;
            references.add(new Pair((Object)realmReference2.getDbPointer(), new WeakReference<FrozenRealmReference>(it)));
        }
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair entry = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)entry.component1();
            WeakReference ref = (WeakReference)entry.component2();
            if (ref.get() == null) {
                this.getLog().debug(Intrinsics.stringPlus((String)"Closing unreferenced version: ", (Object)RealmInterop.INSTANCE.realm_get_version_id(pointer)), new Object[0]);
                RealmInterop.INSTANCE.realm_close(pointer);
                continue;
            }
            references.add(entry);
        }
        this.intermediateReferences.setValue((Object)references);
    }

    public static /* synthetic */ void trackAndCloseExpiredReferences$default(VersionTracker versionTracker, FrozenRealmReference frozenRealmReference, int n, Object object) {
        if ((n & 1) != 0) {
            frozenRealmReference = null;
        }
        versionTracker.trackAndCloseExpiredReferences(frozenRealmReference);
    }

    public final void close() {
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$pointer$_u24__u24 = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)$dstr$pointer$_u24__u24.component1();
            this.getLog().debug(Intrinsics.stringPlus((String)"Closing intermediate version: ", (Object)RealmInterop.INSTANCE.realm_get_version_id(pointer)), new Object[0]);
            RealmInterop.INSTANCE.realm_close(pointer);
        }
    }
}

