/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmObject;
import io.realm.dynamic.DynamicRealmObject;
import io.realm.internal.LiveRealmReference;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmReference;
import io.realm.internal.interop.Link;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.platform.RealmObjectKt;
import io.realm.internal.schema.SchemaMetadata;
import io.realm.internal.util.Validation;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a#\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0006\u001aA\u0010\u0007\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0006\u0010\u0007\u001a\u00020\rH\u0000\u00a2\u0006\u0002\u0010\u000e\u001aA\u0010\u000f\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a!\u0010\u0013\u001a\u0004\u0018\u00010\u0014\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00010\fH\u0080\b\u001a\u001f\u0010\u0016\u001a\u00020\u0014\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\fH\u0080\b\u001a%\u0010\u0017\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a9\u0010\u001b\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"freeze", "T", "Lio/realm/RealmObject;", "Lio/realm/internal/RealmObjectInternal;", "frozenRealm", "Lio/realm/internal/RealmReference;", "(Lio/realm/internal/RealmObjectInternal;Lio/realm/internal/RealmReference;)Lio/realm/RealmObject;", "link", "realm", "mediator", "Lio/realm/internal/Mediator;", "type", "Lkotlin/reflect/KClass;", "Lio/realm/internal/interop/Link;", "(Lio/realm/internal/RealmObjectInternal;Lio/realm/internal/RealmReference;Lio/realm/internal/Mediator;Lkotlin/reflect/KClass;Lio/realm/internal/interop/Link;)Lio/realm/RealmObject;", "manage", "objectPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/RealmObjectInternal;Lio/realm/internal/RealmReference;Lio/realm/internal/Mediator;Lkotlin/reflect/KClass;Lio/realm/internal/interop/NativePointer;)Lio/realm/RealmObject;", "realmObjectCompanionOrNull", "Lio/realm/internal/RealmObjectCompanion;", "", "realmObjectCompanionOrThrow", "thaw", "liveRealm", "Lio/realm/internal/LiveRealmReference;", "(Lio/realm/internal/RealmObjectInternal;Lio/realm/internal/LiveRealmReference;)Lio/realm/RealmObject;", "toRealmObject", "clazz", "(Lio/realm/internal/interop/Link;Lkotlin/reflect/KClass;Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;)Lio/realm/RealmObject;", "io.realm.kotlin.library"})
public final class RealmObjectUtilKt {
    @NotNull
    public static final <T extends RealmObject> T manage(@NotNull RealmObjectInternal $this$manage, @NotNull RealmReference realm, @NotNull Mediator mediator, @NotNull KClass<T> type, @NotNull NativePointer objectPointer) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$manage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)objectPointer, (String)"objectPointer");
        String string2 = type.getSimpleName();
        if (string2 == null) {
            Validation.INSTANCE.sdkError(Intrinsics.stringPlus((String)"Couldn't obtain class name for ", type));
            throw new KotlinNothingValueException();
        }
        String className = string2;
        $this$manage.set$realm$IsManaged(true);
        $this$manage.set$realm$Owner(realm);
        $this$manage.set$realm$Mediator(mediator);
        $this$manage.set$realm$ObjectPointer(objectPointer);
        if ($this$manage instanceof DynamicRealmObject) {
            RealmReference realmReference2 = $this$manage.get$realm$Owner();
            Intrinsics.checkNotNull((Object)realmReference2);
            string = RealmInterop.INSTANCE.realm_get_class-DimupYc(realmReference2.getDbPointer(), RealmInterop.INSTANCE.realm_object_get_table-Zjnb9Kg(objectPointer)).getName();
        } else {
            string = RealmObjectKt.realmObjectCompanionOrThrow(type).get$realm$className();
        }
        $this$manage.set$realm$ClassName(string);
        SchemaMetadata schemaMetadata = realm.getSchemaMetadata();
        String string3 = $this$manage.get$realm$ClassName();
        Intrinsics.checkNotNull((Object)string3);
        $this$manage.set$realm$metadata(schemaMetadata.get(string3));
        return (T)$this$manage;
    }

    @NotNull
    public static final <T extends RealmObject> T link(@NotNull RealmObjectInternal $this$link, @NotNull RealmReference realm, @NotNull Mediator mediator, @NotNull KClass<T> type, @NotNull Link link) {
        Intrinsics.checkNotNullParameter((Object)$this$link, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return RealmObjectUtilKt.manage($this$link, realm, mediator, type, RealmInterop.INSTANCE.realm_get_object(realm.getDbPointer(), link));
    }

    @NotNull
    public static final <T extends RealmObject> T freeze(@NotNull RealmObjectInternal $this$freeze, @NotNull RealmReference frozenRealm) {
        Intrinsics.checkNotNullParameter((Object)$this$freeze, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        RealmObjectInternal realmObjectInternal = $this$freeze.freeze(frozenRealm);
        if (realmObjectInternal == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of io.realm.internal.RealmObjectUtilKt.freeze");
        }
        return (T)realmObjectInternal;
    }

    @Nullable
    public static final <T extends RealmObject> T thaw(@NotNull RealmObjectInternal $this$thaw, @NotNull LiveRealmReference liveRealm) {
        RealmObject realmObject;
        Intrinsics.checkNotNullParameter((Object)$this$thaw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        RealmObjectInternal realmObjectInternal = $this$thaw.thaw(liveRealm);
        if (realmObjectInternal == null) {
            realmObject = null;
        } else {
            RealmObjectInternal it = realmObjectInternal;
            boolean bl = false;
            realmObject = it;
        }
        return (T)realmObject;
    }

    @NotNull
    public static final <T extends RealmObject> T toRealmObject(@NotNull Link $this$toRealmObject, @NotNull KClass<T> clazz, @NotNull Mediator mediator, @NotNull RealmReference realm) {
        Intrinsics.checkNotNullParameter((Object)$this$toRealmObject, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        return RealmObjectUtilKt.link(mediator.createInstanceOf(clazz), realm, mediator, clazz, $this$toRealmObject);
    }

    public static final /* synthetic */ <T> RealmObjectCompanion realmObjectCompanionOrNull(KClass<T> $this$realmObjectCompanionOrNull) {
        Intrinsics.checkNotNullParameter($this$realmObjectCompanionOrNull, (String)"<this>");
        boolean $i$f$realmObjectCompanionOrNull = false;
        return RealmObjectKt.realmObjectCompanionOrNull($this$realmObjectCompanionOrNull);
    }

    public static final /* synthetic */ <T extends RealmObject> RealmObjectCompanion realmObjectCompanionOrThrow(KClass<T> $this$realmObjectCompanionOrThrow) {
        Intrinsics.checkNotNullParameter($this$realmObjectCompanionOrThrow, (String)"<this>");
        boolean $i$f$realmObjectCompanionOrThrow = false;
        return RealmObjectKt.realmObjectCompanionOrThrow($this$realmObjectCompanionOrThrow);
    }
}

