/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.VersionId;
import io.realm.internal.BaseRealmImpl;
import io.realm.internal.RealmState;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.schema.SchemaMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/realm/internal/RealmReference;", "Lio/realm/internal/RealmState;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "getDbPointer", "()Lio/realm/internal/interop/NativePointer;", "owner", "Lio/realm/internal/BaseRealmImpl;", "getOwner", "()Lio/realm/internal/BaseRealmImpl;", "schemaMetadata", "Lio/realm/internal/schema/SchemaMetadata;", "getSchemaMetadata", "()Lio/realm/internal/schema/SchemaMetadata;", "checkClosed", "", "close", "isClosed", "", "isFrozen", "version", "Lio/realm/VersionId;", "io.realm.kotlin.library"})
public interface RealmReference
extends RealmState {
    @NotNull
    public BaseRealmImpl getOwner();

    @NotNull
    public SchemaMetadata getSchemaMetadata();

    @NotNull
    public NativePointer getDbPointer();

    @Override
    @NotNull
    public VersionId version();

    @Override
    public boolean isFrozen();

    @Override
    public boolean isClosed();

    public void close();

    public void checkClosed();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static VersionId version(@NotNull RealmReference this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.checkClosed();
            return new VersionId(RealmInterop.INSTANCE.realm_get_version_id(this_.getDbPointer()));
        }

        public static boolean isFrozen(@NotNull RealmReference this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.checkClosed();
            return RealmInterop.INSTANCE.realm_is_frozen(this_.getDbPointer());
        }

        public static boolean isClosed(@NotNull RealmReference this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return RealmInterop.INSTANCE.realm_is_closed(this_.getDbPointer());
        }

        public static void close(@NotNull RealmReference this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.checkClosed();
            RealmInterop.INSTANCE.realm_close(this_.getDbPointer());
        }

        public static void checkClosed(@NotNull RealmReference this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            if (this_.isClosed()) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_.getOwner().getConfiguration().getPath()));
            }
        }
    }
}

