/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.CompactOnLaunchCallback;
import io.realm.LogConfiguration;
import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.internal.platform.SystemUtilsKt;
import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0001 R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R \u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006!"}, d2={"Lio/realm/Configuration;", "", "compactOnLaunchCallback", "Lio/realm/CompactOnLaunchCallback;", "getCompactOnLaunchCallback", "()Lio/realm/CompactOnLaunchCallback;", "encryptionKey", "", "getEncryptionKey", "()[B", "log", "Lio/realm/LogConfiguration;", "getLog", "()Lio/realm/LogConfiguration;", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "name", "", "getName", "()Ljava/lang/String;", "path", "getPath", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "getSchema", "()Ljava/util/Set;", "schemaVersion", "getSchemaVersion", "SharedBuilder", "io.realm.kotlin.library"})
public interface Configuration {
    @NotNull
    public String getPath();

    @NotNull
    public String getName();

    @NotNull
    public Set<KClass<? extends RealmObject>> getSchema();

    @NotNull
    public LogConfiguration getLog();

    public long getMaxNumberOfActiveVersions();

    public long getSchemaVersion();

    @Nullable
    public byte[] getEncryptionKey();

    @Nullable
    public CompactOnLaunchCallback getCompactOnLaunchCallback();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0013\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010C\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020F2\u0006\u0010!\u001a\u00020\"H\u0004J\u0015\u0010G\u001a\u00028\u00012\b\b\u0002\u0010H\u001a\u00020\n\u00a2\u0006\u0002\u0010IJ\u0013\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010JJ'\u0010K\u001a\u00028\u00012\b\b\u0002\u0010L\u001a\u00020\u00162\u000e\b\u0002\u0010M\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016\u00a2\u0006\u0002\u0010NJ\u0015\u0010\u001b\u001a\u00028\u00012\b\b\u0002\u0010O\u001a\u00020\u001c\u00a2\u0006\u0002\u0010PJ\u0015\u0010!\u001a\u00028\u00012\u0006\u0010!\u001a\u00020\"H&\u00a2\u0006\u0002\u0010QJ\u0017\u0010'\u001a\u00028\u00012\u0006\u0010R\u001a\u00020(H\u0000\u00a2\u0006\u0004\bS\u0010TJ\u000f\u0010-\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\bU\u0010VJ\u0013\u00106\u001a\u00028\u00012\u0006\u00106\u001a\u00020\u001c\u00a2\u0006\u0002\u0010PJ\u0010\u0010W\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0017\u0010@\u001a\u00028\u00012\u0006\u0010R\u001a\u00020(H\u0000\u00a2\u0006\u0004\bX\u0010TR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u0004\u0018\u00010\"X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R(\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u0010\bR\u001a\u00106\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001e\"\u0004\b8\u0010 R \u00109\u001a\b\u0012\u0004\u0012\u00020;0:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010*\"\u0004\bB\u0010,\u00a8\u0006Y"}, d2={"Lio/realm/Configuration$SharedBuilder;", "T", "S", "", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "(Ljava/util/Set;)V", "compactOnLaunchCallback", "Lio/realm/CompactOnLaunchCallback;", "getCompactOnLaunchCallback", "()Lio/realm/CompactOnLaunchCallback;", "setCompactOnLaunchCallback", "(Lio/realm/CompactOnLaunchCallback;)V", "encryptionKey", "", "getEncryptionKey", "()[B", "setEncryptionKey", "([B)V", "logLevel", "Lio/realm/log/LogLevel;", "getLogLevel", "()Lio/realm/log/LogLevel;", "setLogLevel", "(Lio/realm/log/LogLevel;)V", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "setMaxNumberOfActiveVersions", "(J)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "notificationDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getNotificationDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "setNotificationDispatcher", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "removeSystemLogger", "", "getRemoveSystemLogger", "()Z", "setRemoveSystemLogger", "(Z)V", "getSchema", "()Ljava/util/Set;", "setSchema", "schemaVersion", "getSchemaVersion", "setSchemaVersion", "userLoggers", "", "Lio/realm/log/RealmLogger;", "getUserLoggers", "()Ljava/util/List;", "setUserLoggers", "(Ljava/util/List;)V", "writeDispatcher", "getWriteDispatcher", "setWriteDispatcher", "build", "()Ljava/lang/Object;", "checkName", "", "compactOnLaunch", "callback", "(Lio/realm/CompactOnLaunchCallback;)Lio/realm/Configuration$SharedBuilder;", "([B)Lio/realm/Configuration$SharedBuilder;", "log", "level", "customLoggers", "(Lio/realm/log/LogLevel;Ljava/util/List;)Lio/realm/Configuration$SharedBuilder;", "maxVersions", "(J)Lio/realm/Configuration$SharedBuilder;", "(Ljava/lang/String;)Lio/realm/Configuration$SharedBuilder;", "dispatcher", "notificationDispatcher$io_realm_kotlin_library", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lio/realm/Configuration$SharedBuilder;", "removeSystemLogger$io_realm_kotlin_library", "()Lio/realm/Configuration$SharedBuilder;", "validateEncryptionKey", "writeDispatcher$io_realm_kotlin_library", "io.realm.kotlin.library"})
    public static abstract class SharedBuilder<T, S extends SharedBuilder<T, S>> {
        @NotNull
        private Set<? extends KClass<? extends RealmObject>> schema;
        @NotNull
        private LogLevel logLevel;
        private boolean removeSystemLogger;
        @NotNull
        private List<? extends RealmLogger> userLoggers;
        private long maxNumberOfActiveVersions;
        @Nullable
        private CoroutineDispatcher notificationDispatcher;
        @Nullable
        private CoroutineDispatcher writeDispatcher;
        private long schemaVersion;
        @Nullable
        private byte[] encryptionKey;
        @Nullable
        private CompactOnLaunchCallback compactOnLaunchCallback;

        public SharedBuilder(@NotNull Set<? extends KClass<? extends RealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.schema = schema;
            this.logLevel = LogLevel.WARN;
            this.userLoggers = CollectionsKt.emptyList();
            this.maxNumberOfActiveVersions = Long.MAX_VALUE;
        }

        public /* synthetic */ SharedBuilder(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        protected final Set<KClass<? extends RealmObject>> getSchema() {
            return this.schema;
        }

        protected final void setSchema(@NotNull Set<? extends KClass<? extends RealmObject>> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.schema = set;
        }

        @Nullable
        protected abstract String getName();

        protected abstract void setName(@Nullable String var1);

        @NotNull
        protected final LogLevel getLogLevel() {
            return this.logLevel;
        }

        protected final void setLogLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
            this.logLevel = logLevel;
        }

        protected final boolean getRemoveSystemLogger() {
            return this.removeSystemLogger;
        }

        protected final void setRemoveSystemLogger(boolean bl) {
            this.removeSystemLogger = bl;
        }

        @NotNull
        protected final List<RealmLogger> getUserLoggers() {
            return this.userLoggers;
        }

        protected final void setUserLoggers(@NotNull List<? extends RealmLogger> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.userLoggers = list;
        }

        protected final long getMaxNumberOfActiveVersions() {
            return this.maxNumberOfActiveVersions;
        }

        protected final void setMaxNumberOfActiveVersions(long l) {
            this.maxNumberOfActiveVersions = l;
        }

        @Nullable
        protected final CoroutineDispatcher getNotificationDispatcher() {
            return this.notificationDispatcher;
        }

        protected final void setNotificationDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.notificationDispatcher = coroutineDispatcher;
        }

        @Nullable
        protected final CoroutineDispatcher getWriteDispatcher() {
            return this.writeDispatcher;
        }

        protected final void setWriteDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.writeDispatcher = coroutineDispatcher;
        }

        protected final long getSchemaVersion() {
            return this.schemaVersion;
        }

        protected final void setSchemaVersion(long l) {
            this.schemaVersion = l;
        }

        @Nullable
        protected final byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        protected final void setEncryptionKey(@Nullable byte[] byArray) {
            this.encryptionKey = byArray;
        }

        @Nullable
        protected final CompactOnLaunchCallback getCompactOnLaunchCallback() {
            return this.compactOnLaunchCallback;
        }

        protected final void setCompactOnLaunchCallback(@Nullable CompactOnLaunchCallback compactOnLaunchCallback) {
            this.compactOnLaunchCallback = compactOnLaunchCallback;
        }

        @NotNull
        public abstract S name(@NotNull String var1);

        public abstract T build();

        @NotNull
        public final S maxNumberOfActiveVersions(long maxVersions) {
            SharedBuilder sharedBuilder;
            SharedBuilder $this$maxNumberOfActiveVersions_u24lambda_u2d0 = sharedBuilder = this;
            boolean bl = false;
            if (maxVersions < 1L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Only positive numbers above 0 are allowed. Yours was: ", (Object)maxVersions));
            }
            $this$maxNumberOfActiveVersions_u24lambda_u2d0.setMaxNumberOfActiveVersions(maxVersions);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder maxNumberOfActiveVersions$default(SharedBuilder sharedBuilder, long l, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maxNumberOfActiveVersions");
            }
            if ((n & 1) != 0) {
                l = 8L;
            }
            return sharedBuilder.maxNumberOfActiveVersions(l);
        }

        @NotNull
        public S log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            SharedBuilder $this$log_u24lambda_u2d1 = sharedBuilder = this;
            boolean bl = false;
            $this$log_u24lambda_u2d1.setLogLevel(level);
            $this$log_u24lambda_u2d1.setUserLoggers(customLoggers);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder log$default(SharedBuilder sharedBuilder, LogLevel logLevel, List list, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
            }
            if ((n & 1) != 0) {
                logLevel = LogLevel.WARN;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return sharedBuilder.log(logLevel, list);
        }

        @NotNull
        public final S notificationDispatcher$io_realm_kotlin_library(@NotNull CoroutineDispatcher dispatcher) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder $this$notificationDispatcher_u24lambda_u2d2 = sharedBuilder = this;
            boolean bl = false;
            $this$notificationDispatcher_u24lambda_u2d2.setNotificationDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S writeDispatcher$io_realm_kotlin_library(@NotNull CoroutineDispatcher dispatcher) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder $this$writeDispatcher_u24lambda_u2d3 = sharedBuilder = this;
            boolean bl = false;
            $this$writeDispatcher_u24lambda_u2d3.setWriteDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S schemaVersion(long schemaVersion) {
            SharedBuilder sharedBuilder;
            if (schemaVersion < 0L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Realm schema version numbers must be 0 (zero) or higher. Yours was: ", (Object)schemaVersion));
            }
            SharedBuilder $this$schemaVersion_u24lambda_u2d4 = sharedBuilder = this;
            boolean bl = false;
            $this$schemaVersion_u24lambda_u2d4.setSchemaVersion(schemaVersion);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S encryptionKey(@NotNull byte[] encryptionKey) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            SharedBuilder $this$encryptionKey_u24lambda_u2d5 = sharedBuilder = this;
            boolean bl = false;
            $this$encryptionKey_u24lambda_u2d5.setEncryptionKey($this$encryptionKey_u24lambda_u2d5.validateEncryptionKey(encryptionKey));
            return (S)sharedBuilder;
        }

        @NotNull
        public final S compactOnLaunch(@NotNull CompactOnLaunchCallback callback) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            SharedBuilder $this$compactOnLaunch_u24lambda_u2d6 = sharedBuilder = this;
            boolean bl = false;
            $this$compactOnLaunch_u24lambda_u2d6.setCompactOnLaunchCallback(callback);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder compactOnLaunch$default(SharedBuilder sharedBuilder, CompactOnLaunchCallback compactOnLaunchCallback, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compactOnLaunch");
            }
            if ((n & 1) != 0) {
                compactOnLaunchCallback = Realm.Companion.getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK();
            }
            return sharedBuilder.compactOnLaunch(compactOnLaunchCallback);
        }

        @NotNull
        public final S removeSystemLogger$io_realm_kotlin_library() {
            SharedBuilder sharedBuilder;
            SharedBuilder $this$removeSystemLogger_u24lambda_u2d7 = sharedBuilder = this;
            boolean bl = false;
            $this$removeSystemLogger_u24lambda_u2d7.setRemoveSystemLogger(true);
            return (S)sharedBuilder;
        }

        @NotNull
        protected final byte[] validateEncryptionKey(@NotNull byte[] encryptionKey) {
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            if (encryptionKey.length != 64) {
                throw new IllegalArgumentException("The provided key must be 64 bytes. The provided key was " + encryptionKey.length + " bytes.");
            }
            return encryptionKey;
        }

        protected final void checkName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!(((CharSequence)name).length() > 0)) {
                boolean $i$a$-require-Configuration$SharedBuilder$checkName$42 = false;
                String $i$a$-require-Configuration$SharedBuilder$checkName$42 = "A non-empty filename must be provided.";
                throw new IllegalArgumentException($i$a$-require-Configuration$SharedBuilder$checkName$42.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)name, (CharSequence)SystemUtilsKt.getPATH_SEPARATOR(), (boolean)false, (int)2, null))) {
                boolean $i$a$-require-Configuration$SharedBuilder$checkName$52 = false;
                String $i$a$-require-Configuration$SharedBuilder$checkName$52 = "Name cannot contain path separator '" + SystemUtilsKt.getPATH_SEPARATOR() + "': '" + name + '\'';
                throw new IllegalArgumentException($i$a$-require-Configuration$SharedBuilder$checkName$52.toString());
            }
            if (!(!Intrinsics.areEqual((Object)name, (Object)".realm"))) {
                boolean bl = false;
                String string = "'.realm' is not a valid filename";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public SharedBuilder() {
            this(null, 1, null);
        }
    }
}

