/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Deleteable;
import io.realm.MutableRealm;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.internal.LiveRealmReference;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectReference;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmValueArgumentConverter;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreAddressSpaceExhaustedException;
import io.realm.internal.interop.RealmCoreCallbackException;
import io.realm.internal.interop.RealmCoreColumnAlreadyExistsException;
import io.realm.internal.interop.RealmCoreColumnNotFoundException;
import io.realm.internal.interop.RealmCoreCrossTableLinkTargetException;
import io.realm.internal.interop.RealmCoreDeleteOpenRealmException;
import io.realm.internal.interop.RealmCoreDuplicatePrimaryKeyValueException;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreFileAccessErrorException;
import io.realm.internal.interop.RealmCoreFilePermissionDeniedException;
import io.realm.internal.interop.RealmCoreIllegalOperationException;
import io.realm.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.internal.interop.RealmCoreInvalidArgumentException;
import io.realm.internal.interop.RealmCoreInvalidPathErrorException;
import io.realm.internal.interop.RealmCoreInvalidPropertyException;
import io.realm.internal.interop.RealmCoreInvalidQueryException;
import io.realm.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.internal.interop.RealmCoreInvalidatedObjectException;
import io.realm.internal.interop.RealmCoreKeyAlreadyUsedException;
import io.realm.internal.interop.RealmCoreKeyNotFoundException;
import io.realm.internal.interop.RealmCoreLogicException;
import io.realm.internal.interop.RealmCoreMaximumFileSizeExceededException;
import io.realm.internal.interop.RealmCoreMissingPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMissingPropertyValueException;
import io.realm.internal.interop.RealmCoreModifyPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMultipleSyncAgentsException;
import io.realm.internal.interop.RealmCoreNoSuchObjectException;
import io.realm.internal.interop.RealmCoreNoSuchTableException;
import io.realm.internal.interop.RealmCoreNoneException;
import io.realm.internal.interop.RealmCoreNotClonableException;
import io.realm.internal.interop.RealmCoreNotInATransactionException;
import io.realm.internal.interop.RealmCoreOtherException;
import io.realm.internal.interop.RealmCoreOutOfDiskSpaceException;
import io.realm.internal.interop.RealmCoreOutOfMemoryException;
import io.realm.internal.interop.RealmCorePropertyNotNullableException;
import io.realm.internal.interop.RealmCorePropertyTypeMismatchException;
import io.realm.internal.interop.RealmCoreReadOnlyPropertyException;
import io.realm.internal.interop.RealmCoreSerializationErrorException;
import io.realm.internal.interop.RealmCoreUnexpectedPrimaryKeyException;
import io.realm.internal.interop.RealmCoreUnknownException;
import io.realm.internal.interop.RealmCoreUnsupportedFileFormatVersionException;
import io.realm.internal.interop.RealmCoreWrongPrimaryKeyTypeException;
import io.realm.internal.interop.RealmCoreWrongThreadException;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.interop.RealmObjectT;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0013\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0080\b\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aO\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\t2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0013H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a5\u0010\u0015\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001aM\u0010\u0015\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a=\u0010\u0015\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u001e\u001aU\u0010\u0015\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0000\u001au\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0&\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0006\u0012\u0004\u0018\u00010'0*2\u0006\u0010+\u001a\u0002H\t2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010-\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006."}, d2={"REPLACED_BY_IR", "", "message", "", "checkRealmClosed", "", "realm", "Lio/realm/internal/RealmReference;", "copyToRealm", "T", "Lio/realm/RealmObject;", "mediator", "Lio/realm/internal/Mediator;", "realmReference", "Lio/realm/internal/LiveRealmReference;", "element", "updatePolicy", "Lio/realm/MutableRealm$UpdatePolicy;", "cache", "", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Lio/realm/RealmObject;Lio/realm/MutableRealm$UpdatePolicy;Ljava/util/Map;)Lio/realm/RealmObject;", "create", "type", "Lkotlin/reflect/KClass;", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Lkotlin/reflect/KClass;)Lio/realm/RealmObject;", "primaryKey", "Lio/realm/internal/interop/RealmValue;", "create-7YOpjY0", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Lkotlin/reflect/KClass;Ljava/lang/Object;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmObject;", "className", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Lkotlin/reflect/KClass;Ljava/lang/String;)Lio/realm/RealmObject;", "create-DY5HpUg", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/lang/Object;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmObject;", "genericRealmCoreExceptionHandler", "", "cause", "Lio/realm/internal/interop/RealmCoreException;", "processListMember", "Lio/realm/RealmList;", "", "realmPointer", "member", "Lkotlin/reflect/KMutableProperty1;", "target", "sourceObject", "(Lio/realm/internal/Mediator;Lio/realm/internal/LiveRealmReference;Ljava/util/Map;Lkotlin/reflect/KMutableProperty1;Lio/realm/RealmObject;Lio/realm/RealmList;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmList;", "io.realm.kotlin.library"})
public final class RealmUtilsKt {
    @NotNull
    public static final Void REPLACED_BY_IR(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static /* synthetic */ Void REPLACED_BY_IR$default(String message, int n, Object object) {
        if ((n & 1) != 0) {
            message = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static final void checkRealmClosed(@NotNull RealmReference realm) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        if (RealmInterop.INSTANCE.realm_is_closed(realm.getDbPointer())) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)realm.getOwner().getConfiguration().getPath()));
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull LiveRealmReference realm, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return RealmUtilsKt.create(mediator, realm, type, io.realm.internal.platform.RealmObjectKt.realmObjectCompanionOrThrow(type).getIo_realm_kotlin_className());
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull LiveRealmReference realm, @NotNull KClass<T> type, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            long key;
            long l;
            long it = l = (key = realm.getSchemaMetadata().getOrThrow(className).getClassKey-gequ3zM());
            boolean bl = false;
            T t = RealmObjectUtilKt.toRealmObject((NativePointer<RealmObjectT>)RealmInterop.INSTANCE.realm_object_create-DimupYc(realm.getDbPointer(), key), type, mediator, (RealmReference)realm);
            if (t == null) {
                throw new IllegalArgumentException("Schema doesn't include class '" + className + '\'');
            }
            return t;
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + className + '\'', e);
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create-7YOpjY0(@NotNull Mediator mediator, @NotNull LiveRealmReference realm, @NotNull KClass<T> type, @NotNull Object primaryKey, @NotNull MutableRealm.UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        return RealmUtilsKt.create-DY5HpUg(mediator, realm, type, io.realm.internal.platform.RealmObjectKt.realmObjectCompanionOrThrow(type).getIo_realm_kotlin_className(), primaryKey, updatePolicy);
    }

    @NotNull
    public static final <T extends RealmObject> T create-DY5HpUg(@NotNull Mediator mediator, @NotNull LiveRealmReference realm, @NotNull KClass<T> type, @NotNull String className, @NotNull Object primaryKey, @NotNull MutableRealm.UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        try {
            NativePointer nativePointer;
            long key;
            long l;
            long it = l = (key = realm.getSchemaMetadata().getOrThrow(className).getClassKey-gequ3zM());
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[updatePolicy.ordinal()]) {
                case 1: {
                    nativePointer = RealmInterop.INSTANCE.realm_object_create_with_primary_key-36wAgJU(realm.getDbPointer(), key, primaryKey);
                    break;
                }
                case 2: {
                    nativePointer = RealmInterop.INSTANCE.realm_object_get_or_create_with_primary_key-36wAgJU(realm.getDbPointer(), key, primaryKey);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            T t = RealmObjectUtilKt.toRealmObject((NativePointer<RealmObjectT>)nativePointer, type, mediator, (RealmReference)realm);
            if (t == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Couldn't find key for class ", (Object)className).toString());
            }
            return t;
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + className + '\'', e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends RealmObject> T copyToRealm(@NotNull Mediator mediator, @NotNull LiveRealmReference realmReference2, @NotNull T element, @NotNull MutableRealm.UpdatePolicy updatePolicy, @NotNull Map<RealmObject, RealmObject> cache) {
        Iterator<KMutableProperty1<?, ?>> iterator;
        Iterator<KMutableProperty1<?, ?>> iterator2;
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realmReference2, (String)"realmReference");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        if (!RealmObjectKt.isValid(element)) {
            throw new IllegalArgumentException("Cannot copy an invalid managed object to Realm.");
        }
        T $this$runIfManaged$iv = element;
        boolean $i$f$runIfManaged = false;
        RealmObjectReference<? extends RealmObject> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference($this$runIfManaged$iv);
        if (realmObjectReference == null) {
            iterator2 = null;
        } else {
            RealmObjectReference<? extends RealmObject> $this$copyToRealm_u24lambda_u2d2 = realmObjectReference;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)$this$copyToRealm_u24lambda_u2d2.getOwner(), (Object)realmReference2)) {
                iterator2 = (Iterator<KMutableProperty1<?, ?>>)((Object)element);
            } else {
                throw new IllegalArgumentException("Cannot set/copyToRealm an outdated object. User findLatest(object) to find the version of the object required in the given context.");
            }
        }
        Iterator<KMutableProperty1<?, ?>> iterator3 = iterator2;
        if (iterator3 == null) {
            Iterator<Object> iterator4;
            KMutableProperty1<?, ?> primaryKeyMember;
            boolean bl = false;
            T instance = element;
            RealmObjectCompanion companion = mediator.companionOf((KClass<? extends RealmObject>)Reflection.getOrCreateKotlinClass(instance.getClass()));
            List<KMutableProperty1<?, ?>> list = companion.getIo_realm_kotlin_fields();
            if (list == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.reflect.KMutableProperty1<io.realm.RealmObject, kotlin.Any?>>");
            }
            List<KMutableProperty1<?, ?>> members = list;
            KMutableProperty1<?, ?> kMutableProperty1 = primaryKeyMember = companion.getIo_realm_kotlin_primaryKey();
            if (kMutableProperty1 == null) {
                iterator4 = null;
            } else {
                KMutableProperty1<?, ?> primaryKey = kMutableProperty1;
                boolean bl2 = false;
                iterator4 = RealmUtilsKt.create-7YOpjY0(mediator, realmReference2, Reflection.getOrCreateKotlinClass(instance.getClass()), RealmValueArgumentConverter.INSTANCE.convertArg-rM675rY(((KProperty1)primaryKey).get(instance)), updatePolicy);
            }
            Iterator<KMutableProperty1<?, ?>> iterator5 = iterator4;
            Iterator<KMutableProperty1<?, ?>> target = iterator5 == null ? (Iterator<KMutableProperty1<?, ?>>)RealmUtilsKt.create(mediator, realmReference2, Reflection.getOrCreateKotlinClass(instance.getClass())) : iterator5;
            cache.put(instance, (RealmObject)((Object)target));
            for (KMutableProperty1<?, ?> member : members) {
                RealmList<Object> it;
                RealmList<Object> targetValue;
                Deleteable deleteable;
                if (Intrinsics.areEqual(member, primaryKeyMember)) continue;
                RealmList<Object> sourceObject = member.get(instance);
                boolean bl3 = false;
                if (sourceObject instanceof RealmObjectInternal && !RealmObjectKt.isManaged((RealmObject)((Object)sourceObject))) {
                    void $this$getOrPut$iv;
                    Map<RealmObject, RealmObject> map2 = cache;
                    RealmList<Object> key$iv = sourceObject;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        RealmObject answer$iv = RealmUtilsKt.copyToRealm(mediator, realmReference2, (RealmObject)((Object)sourceObject), updatePolicy, cache);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        deleteable = answer$iv;
                    } else {
                        deleteable = value$iv;
                    }
                } else {
                    deleteable = sourceObject instanceof RealmList ? RealmUtilsKt.processListMember(mediator, realmReference2, cache, member, target, sourceObject, updatePolicy) : sourceObject;
                }
                if ((targetValue = deleteable) == null) continue;
                boolean bl5 = false;
                member.set(target, it);
            }
            iterator = target;
        } else {
            iterator = iterator3;
        }
        return (T)iterator;
    }

    public static /* synthetic */ RealmObject copyToRealm$default(Mediator mediator, LiveRealmReference liveRealmReference, RealmObject realmObject, MutableRealm.UpdatePolicy updatePolicy, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            updatePolicy = MutableRealm.UpdatePolicy.ERROR;
        }
        if ((n & 0x10) != 0) {
            map2 = new LinkedHashMap();
        }
        return RealmUtilsKt.copyToRealm(mediator, liveRealmReference, realmObject, updatePolicy, map2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends RealmObject> RealmList<Object> processListMember(Mediator mediator, LiveRealmReference realmPointer, Map<RealmObject, RealmObject> cache, KMutableProperty1<T, Object> member, T target, RealmList<?> sourceObject, MutableRealm.UpdatePolicy updatePolicy) {
        Object object = member.get(target);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.realm.RealmList<kotlin.Any?>");
        }
        RealmList list = (RealmList)object;
        list.clear();
        for (Object item : sourceObject) {
            if (item instanceof RealmObject && !RealmObjectKt.isManaged((RealmObject)item)) {
                Object object2;
                void $this$getOrPut$iv;
                Map<RealmObject, RealmObject> map2 = cache;
                Object key$iv = item;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    RealmObject answer$iv = RealmUtilsKt.copyToRealm(mediator, realmPointer, (RealmObject)item, updatePolicy, cache);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                RealmObject value = (RealmObject)object2;
                list.add(value);
                continue;
            }
            list.add(item);
        }
        return list;
    }

    @NotNull
    public static final Throwable genericRealmCoreExceptionHandler(@NotNull String message, @NotNull RealmCoreException cause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        RealmCoreException realmCoreException = cause;
        if ((((((realmCoreException instanceof RealmCoreOutOfMemoryException ? true : realmCoreException instanceof RealmCoreUnsupportedFileFormatVersionException) ? true : realmCoreException instanceof RealmCoreInvalidPathErrorException) ? true : realmCoreException instanceof RealmCoreMultipleSyncAgentsException) ? true : realmCoreException instanceof RealmCoreAddressSpaceExhaustedException) ? true : realmCoreException instanceof RealmCoreMaximumFileSizeExceededException) ? true : realmCoreException instanceof RealmCoreOutOfDiskSpaceException) {
            throwable = new Error(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if (realmCoreException instanceof RealmCoreIndexOutOfBoundsException) {
            throwable = new IndexOutOfBoundsException(message + ": RealmCoreException(" + cause.getMessage() + ')');
        } else if ((((((((realmCoreException instanceof RealmCoreInvalidArgumentException ? true : realmCoreException instanceof RealmCoreInvalidQueryStringException) ? true : realmCoreException instanceof RealmCoreOtherException) ? true : realmCoreException instanceof RealmCoreInvalidQueryException) ? true : realmCoreException instanceof RealmCoreMissingPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreUnexpectedPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreWrongPrimaryKeyTypeException) ? true : realmCoreException instanceof RealmCoreModifyPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreDuplicatePrimaryKeyValueException) {
            throwable = new IllegalArgumentException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if ((((realmCoreException instanceof RealmCoreNotInATransactionException ? true : realmCoreException instanceof RealmCoreDeleteOpenRealmException) ? true : realmCoreException instanceof RealmCoreFileAccessErrorException) ? true : realmCoreException instanceof RealmCoreFilePermissionDeniedException) ? true : realmCoreException instanceof RealmCoreLogicException) {
            throwable = new IllegalStateException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if (((((((((((((((((((realmCoreException instanceof RealmCoreNoneException ? true : realmCoreException instanceof RealmCoreUnknownException) ? true : realmCoreException instanceof RealmCoreNotClonableException) ? true : realmCoreException instanceof RealmCoreWrongThreadException) ? true : realmCoreException instanceof RealmCoreInvalidatedObjectException) ? true : realmCoreException instanceof RealmCoreInvalidPropertyException) ? true : realmCoreException instanceof RealmCoreMissingPropertyValueException) ? true : realmCoreException instanceof RealmCorePropertyTypeMismatchException) ? true : realmCoreException instanceof RealmCoreReadOnlyPropertyException) ? true : realmCoreException instanceof RealmCorePropertyNotNullableException) ? true : realmCoreException instanceof RealmCoreNoSuchTableException) ? true : realmCoreException instanceof RealmCoreNoSuchObjectException) ? true : realmCoreException instanceof RealmCoreCrossTableLinkTargetException) ? true : realmCoreException instanceof RealmCoreKeyNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnAlreadyExistsException) ? true : realmCoreException instanceof RealmCoreKeyAlreadyUsedException) ? true : realmCoreException instanceof RealmCoreSerializationErrorException) ? true : realmCoreException instanceof RealmCoreIllegalOperationException) ? true : realmCoreException instanceof RealmCoreCallbackException) {
            throwable = new RuntimeException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MutableRealm.UpdatePolicy.values().length];
            nArray[MutableRealm.UpdatePolicy.ERROR.ordinal()] = 1;
            nArray[MutableRealm.UpdatePolicy.ALL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

