/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmReference;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreAddressSpaceExhaustedException;
import io.realm.internal.interop.RealmCoreCallbackException;
import io.realm.internal.interop.RealmCoreColumnAlreadyExistsException;
import io.realm.internal.interop.RealmCoreColumnNotFoundException;
import io.realm.internal.interop.RealmCoreCrossTableLinkTargetException;
import io.realm.internal.interop.RealmCoreDuplicatePrimaryKeyValueException;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.internal.interop.RealmCoreInvalidArgumentException;
import io.realm.internal.interop.RealmCoreInvalidPathErrorException;
import io.realm.internal.interop.RealmCoreInvalidPropertyException;
import io.realm.internal.interop.RealmCoreInvalidQueryException;
import io.realm.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.internal.interop.RealmCoreInvalidatedObjectException;
import io.realm.internal.interop.RealmCoreKeyAlreadyUsedException;
import io.realm.internal.interop.RealmCoreKeyNotFoundException;
import io.realm.internal.interop.RealmCoreLogicException;
import io.realm.internal.interop.RealmCoreMaximumFileSizeExceededException;
import io.realm.internal.interop.RealmCoreMissingPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMissingPropertyValueException;
import io.realm.internal.interop.RealmCoreModifyPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMultipleSyncAgentsException;
import io.realm.internal.interop.RealmCoreNoSuchObjectException;
import io.realm.internal.interop.RealmCoreNoSuchTableException;
import io.realm.internal.interop.RealmCoreNoneException;
import io.realm.internal.interop.RealmCoreNotClonableException;
import io.realm.internal.interop.RealmCoreNotInATransactionException;
import io.realm.internal.interop.RealmCoreOtherException;
import io.realm.internal.interop.RealmCoreOutOfDiskSpaceException;
import io.realm.internal.interop.RealmCoreOutOfMemoryException;
import io.realm.internal.interop.RealmCorePropertyNotNullableException;
import io.realm.internal.interop.RealmCorePropertyTypeMismatchException;
import io.realm.internal.interop.RealmCoreReadOnlyPropertyException;
import io.realm.internal.interop.RealmCoreSerializationErrorException;
import io.realm.internal.interop.RealmCoreUnexpectedPrimaryKeyException;
import io.realm.internal.interop.RealmCoreUnknownException;
import io.realm.internal.interop.RealmCoreUnsupportedFileFormatVersionException;
import io.realm.internal.interop.RealmCoreWrongPrimaryKeyTypeException;
import io.realm.internal.interop.RealmCoreWrongThreadException;
import io.realm.internal.interop.RealmInterop;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0013\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0086\b\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aA\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u0002H\t2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a2\u0006\u0002\u0010\u0011\u001a5\u0010\u0012\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a?\u0010\u0012\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d\u001am\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001f\"\b\b\u0000\u0010\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0006\u0012\u0004\u0018\u00010\u00180!2\u0006\u0010\"\u001a\u0002H\t2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"REPLACED_BY_IR", "", "message", "", "checkRealmClosed", "", "realm", "Lio/realm/internal/RealmReference;", "copyToRealm", "T", "mediator", "Lio/realm/internal/Mediator;", "realmPointer", "element", "cache", "", "Lio/realm/internal/RealmObjectInternal;", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/Object;", "create", "Lio/realm/RealmObject;", "type", "Lkotlin/reflect/KClass;", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;)Lio/realm/RealmObject;", "primaryKey", "", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;Ljava/lang/Object;)Lio/realm/RealmObject;", "genericRealmCoreExceptionHandler", "", "cause", "Lio/realm/internal/interop/RealmCoreException;", "processListMember", "Lio/realm/RealmList;", "member", "Lkotlin/reflect/KMutableProperty1;", "target", "sourceObject", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Ljava/util/Map;Lkotlin/reflect/KMutableProperty1;Lio/realm/RealmObject;Lio/realm/RealmList;)Lio/realm/RealmList;", "library-base_release"})
public final class RealmUtilsKt {
    @NotNull
    public static final Void REPLACED_BY_IR(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static /* synthetic */ Void REPLACED_BY_IR$default(String message, int n, Object object) {
        if ((n & 1) != 0) {
            message = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static final void checkRealmClosed(@NotNull RealmReference realm) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        if (RealmInterop.INSTANCE.realm_is_closed(realm.getDbPointer())) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)realm.getOwner().getConfiguration().getPath()));
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getSimpleName();
        if (string == null) {
            String string2 = "Cannot get class name";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String objectType = string;
        try {
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            long key = RealmInterop.INSTANCE.realm_find_class-6I3TXXU(realm.getDbPointer(), objectType);
            return RealmObjectUtilKt.manage(managedModel, realm, mediator, type, RealmInterop.INSTANCE.realm_object_create-DimupYc(realm.getDbPointer(), key));
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + objectType + '\'', e);
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type, @Nullable Object primaryKey) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getSimpleName();
        if (string == null) {
            String string2 = "Cannot get class name";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String objectType = string;
        try {
            NativePointer existingPrimaryKeyObject;
            long key = RealmInterop.INSTANCE.realm_find_class-6I3TXXU(realm.getDbPointer(), objectType);
            NativePointer nativePointer = existingPrimaryKeyObject = RealmInterop.INSTANCE.realm_object_find_with_primary_key-CEpJScw(realm.getDbPointer(), key, primaryKey);
            if (nativePointer != null) {
                NativePointer nativePointer2 = nativePointer;
                boolean bl = false;
                boolean bl2 = false;
                NativePointer it = nativePointer2;
                boolean bl3 = false;
                throw new IllegalArgumentException("Cannot create object with existing primary key");
            }
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            return RealmObjectUtilKt.manage(managedModel, realm, mediator, type, RealmInterop.INSTANCE.realm_object_create_with_primary_key-CEpJScw(realm.getDbPointer(), key, primaryKey));
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + objectType + '\'', e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T copyToRealm(@NotNull Mediator mediator, @NotNull RealmReference realmPointer, T element, @NotNull Map<RealmObjectInternal, RealmObjectInternal> cache) {
        T t;
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realmPointer, (String)"realmPointer");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        if (element instanceof RealmObjectInternal) {
            Object elementToCopy = element;
            if (!RealmObjectKt.isValid((RealmObject)elementToCopy)) {
                throw new IllegalStateException("Cannot copy an invalid managed object to Realm.");
            }
            if (!RealmObjectKt.isManaged((RealmObject)elementToCopy)) {
                boolean bl;
                Object object;
                RealmObjectInternal instance = (RealmObjectInternal)element;
                RealmObjectCompanion companion = mediator.companionOf((KClass<? extends RealmObject>)Reflection.getOrCreateKotlinClass(instance.getClass()));
                List<KMutableProperty1<?, ?>> list = companion.get$realm$fields();
                if (list == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.reflect.KMutableProperty1<io.realm.internal.RealmObjectInternal, kotlin.Any?>>");
                }
                List<KMutableProperty1<?, ?>> members = list;
                KMutableProperty1<?, ?> kMutableProperty1 = companion.get$realm$primaryKey();
                if (kMutableProperty1 == null) {
                    object = null;
                } else {
                    KMutableProperty1<?, ?> kMutableProperty12 = kMutableProperty1;
                    boolean bl2 = false;
                    bl = false;
                    KMutableProperty1<?, ?> primaryKey = kMutableProperty12;
                    boolean bl3 = false;
                    object = (RealmObjectInternal)RealmUtilsKt.create(mediator, realmPointer, Reflection.getOrCreateKotlinClass(instance.getClass()), primaryKey.get((Object)instance));
                }
                Object object2 = object;
                Map<RealmObjectInternal, RealmObjectInternal> target = object2 == null ? (RealmObjectInternal)RealmUtilsKt.create(mediator, realmPointer, Reflection.getOrCreateKotlinClass(instance.getClass())) : object2;
                object2 = cache;
                boolean bl4 = false;
                object2.put((RealmObjectInternal)instance, target);
                for (KMutableProperty1 kMutableProperty12 : members) {
                    RealmList<Object> targetValue;
                    RealmList<Object> realmList;
                    RealmList<Object> realmList2 = kMutableProperty12.get((Object)instance);
                    bl = false;
                    boolean bl5 = false;
                    RealmList<Object> sourceObject = realmList2;
                    boolean bl6 = false;
                    if (sourceObject instanceof RealmObjectInternal && !((RealmObjectInternal)((Object)sourceObject)).get$realm$IsManaged()) {
                        void $this$getOrPut$iv;
                        Map<RealmObjectInternal, RealmObjectInternal> map = cache;
                        RealmList<Object> key$iv = sourceObject;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl7 = false;
                            RealmObjectInternal answer$iv = (RealmObjectInternal)((Object)RealmUtilsKt.copyToRealm(mediator, realmPointer, sourceObject, cache));
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            realmList = answer$iv;
                        } else {
                            realmList = value$iv;
                        }
                    } else {
                        realmList = sourceObject instanceof RealmList ? RealmUtilsKt.processListMember(mediator, realmPointer, cache, kMutableProperty12, (RealmObject)((Object)target), sourceObject) : sourceObject;
                    }
                    if ((realmList2 = (targetValue = realmList)) == null) continue;
                    RealmList<Object> realmList3 = realmList2;
                    bl5 = false;
                    boolean bl8 = false;
                    RealmList<Object> it = realmList3;
                    boolean bl9 = false;
                    kMutableProperty12.set(target, it);
                }
                elementToCopy = target;
            }
            t = elementToCopy;
        } else {
            t = element;
        }
        return t;
    }

    public static /* synthetic */ Object copyToRealm$default(Mediator mediator, RealmReference realmReference, Object object, Map map, int n, Object object2) {
        if ((n & 8) != 0) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        return RealmUtilsKt.copyToRealm(mediator, realmReference, object, map);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends RealmObject> RealmList<Object> processListMember(Mediator mediator, RealmReference realmPointer, Map<RealmObjectInternal, RealmObjectInternal> cache, KMutableProperty1<T, Object> member, T target, RealmList<?> sourceObject) {
        Iterator iterator = member.get(target);
        if (iterator == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.realm.RealmList<kotlin.Any?>");
        }
        RealmList list = (RealmList)((Object)iterator);
        for (Object item : sourceObject) {
            if (item instanceof RealmObjectInternal && !((RealmObjectInternal)item).get$realm$IsManaged()) {
                Object object;
                void $this$getOrPut$iv;
                Map<RealmObjectInternal, RealmObjectInternal> map = cache;
                Object key$iv = item;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    RealmObjectInternal answer$iv = (RealmObjectInternal)RealmUtilsKt.copyToRealm(mediator, realmPointer, item, cache);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                RealmObjectInternal value = (RealmObjectInternal)object;
                list.add(value);
                continue;
            }
            list.add(item);
        }
        return list;
    }

    @NotNull
    public static final Throwable genericRealmCoreExceptionHandler(@NotNull String message, @NotNull RealmCoreException cause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        RealmCoreException realmCoreException = cause;
        if ((((((realmCoreException instanceof RealmCoreOutOfMemoryException ? true : realmCoreException instanceof RealmCoreUnsupportedFileFormatVersionException) ? true : realmCoreException instanceof RealmCoreInvalidPathErrorException) ? true : realmCoreException instanceof RealmCoreMultipleSyncAgentsException) ? true : realmCoreException instanceof RealmCoreAddressSpaceExhaustedException) ? true : realmCoreException instanceof RealmCoreMaximumFileSizeExceededException) ? true : realmCoreException instanceof RealmCoreOutOfDiskSpaceException) {
            throwable = new Error(message, cause);
        } else if (realmCoreException instanceof RealmCoreIndexOutOfBoundsException) {
            throwable = new IndexOutOfBoundsException(message);
        } else if ((((((((realmCoreException instanceof RealmCoreInvalidArgumentException ? true : realmCoreException instanceof RealmCoreInvalidQueryStringException) ? true : realmCoreException instanceof RealmCoreOtherException) ? true : realmCoreException instanceof RealmCoreInvalidQueryException) ? true : realmCoreException instanceof RealmCoreMissingPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreUnexpectedPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreWrongPrimaryKeyTypeException) ? true : realmCoreException instanceof RealmCoreModifyPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreDuplicatePrimaryKeyValueException) {
            throwable = new IllegalArgumentException(message, cause);
        } else if (realmCoreException instanceof RealmCoreNotInATransactionException ? true : realmCoreException instanceof RealmCoreLogicException) {
            throwable = new IllegalStateException(message, cause);
        } else if ((((((((((((((((((realmCoreException instanceof RealmCoreNoneException ? true : realmCoreException instanceof RealmCoreUnknownException) ? true : realmCoreException instanceof RealmCoreNotClonableException) ? true : realmCoreException instanceof RealmCoreWrongThreadException) ? true : realmCoreException instanceof RealmCoreInvalidatedObjectException) ? true : realmCoreException instanceof RealmCoreInvalidPropertyException) ? true : realmCoreException instanceof RealmCoreMissingPropertyValueException) ? true : realmCoreException instanceof RealmCorePropertyTypeMismatchException) ? true : realmCoreException instanceof RealmCoreReadOnlyPropertyException) ? true : realmCoreException instanceof RealmCorePropertyNotNullableException) ? true : realmCoreException instanceof RealmCoreNoSuchTableException) ? true : realmCoreException instanceof RealmCoreNoSuchObjectException) ? true : realmCoreException instanceof RealmCoreCrossTableLinkTargetException) ? true : realmCoreException instanceof RealmCoreKeyNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnAlreadyExistsException) ? true : realmCoreException instanceof RealmCoreKeyAlreadyUsedException) ? true : realmCoreException instanceof RealmCoreSerializationErrorException) ? true : realmCoreException instanceof RealmCoreCallbackException) {
            throwable = new RuntimeException(message, cause);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }
}

