/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmList;
import io.realm.internal.ListOperator;
import io.realm.internal.ListOperatorMetadata;
import io.realm.internal.Observable;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.interop.Callback;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmInterop;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016JB\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000$H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010'\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010(J\r\u0010)\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b*J\u0014\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000,H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0016J\u0015\u00101\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010(J\u001e\u00102\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00105\u001a\u00020!H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00066"}, d2={"Lio/realm/internal/ManagedRealmList;", "E", "Lkotlin/collections/AbstractMutableList;", "Lio/realm/RealmList;", "Lio/realm/internal/Observable;", "nativePointer", "Lio/realm/internal/interop/NativePointer;", "metadata", "Lio/realm/internal/ListOperatorMetadata;", "(Lio/realm/internal/interop/NativePointer;Lio/realm/internal/ListOperatorMetadata;)V", "getMetadata", "()Lio/realm/internal/ListOperatorMetadata;", "getNativePointer", "()Lio/realm/internal/interop/NativePointer;", "operator", "Lio/realm/internal/ListOperator;", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "addAll", "", "elements", "", "clear", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "Lio/realm/internal/RealmReference;", "change", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "get", "(I)Ljava/lang/Object;", "isValid", "isValid$library_base_release", "observe", "Lkotlinx/coroutines/flow/Flow;", "rangeCheckForAdd", "registerForNotification", "callback", "Lio/realm/internal/interop/Callback;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "thaw", "liveRealm", "library-base_release"})
public final class ManagedRealmList<E>
extends AbstractMutableList<E>
implements RealmList<E>,
Observable<ManagedRealmList<E>> {
    @NotNull
    private final NativePointer nativePointer;
    @NotNull
    private final ListOperatorMetadata metadata;
    @NotNull
    private final ListOperator<E> operator;

    public ManagedRealmList(@NotNull NativePointer nativePointer, @NotNull ListOperatorMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.nativePointer = nativePointer;
        this.metadata = metadata;
        this.operator = new ListOperator(this.metadata);
    }

    @NotNull
    public final NativePointer getNativePointer() {
        return this.nativePointer;
    }

    @NotNull
    public final ListOperatorMetadata getMetadata() {
        return this.metadata;
    }

    public int getSize() {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return (int)RealmInterop.INSTANCE.realm_list_size(this.nativePointer);
    }

    @Override
    public E get(int index) {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        try {
            return this.operator.convert(RealmInterop.INSTANCE.realm_list_get(this.nativePointer, (long)index));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not get element at list index ", (Object)index), exception);
        }
    }

    @Override
    public void add(int index, E element) {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        try {
            RealmInterop.INSTANCE.realm_list_add(this.nativePointer, (long)index, RealmUtilsKt.copyToRealm$default(this.metadata.getMediator(), this.metadata.getRealm(), element, null, 8, null));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not add element at list index ", (Object)index), exception);
        }
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        this.rangeCheckForAdd(index);
        return super.addAll(index, elements);
    }

    @Override
    public void clear() {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        RealmInterop.INSTANCE.realm_list_clear(this.nativePointer);
    }

    public E removeAt(int index) {
        E e;
        E it = e = this.get(index);
        boolean bl = false;
        RealmReference this_$iv = this.getMetadata().getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        try {
            RealmInterop.INSTANCE.realm_list_erase(this.getNativePointer(), (long)index);
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not remove element at list index ", (Object)index), exception);
        }
        return e;
    }

    @Override
    public E set(int index, E element) {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        try {
            return this.operator.convert(RealmInterop.INSTANCE.realm_list_set(this.nativePointer, (long)index, RealmUtilsKt.copyToRealm$default(this.metadata.getMediator(), this.metadata.getRealm(), element, null, 8, null)));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not set list element at list index ", (Object)index), exception);
        }
    }

    @Override
    @NotNull
    public Flow<ManagedRealmList<E>> observe() {
        RealmReference this_$iv = this.metadata.getRealm();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return this.metadata.getRealm().getOwner().registerObserver$library_base_release(this);
    }

    @Override
    @Nullable
    public ManagedRealmList<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer == null) {
            managedRealmList = null;
        } else {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(it, ListOperatorMetadata.copy$default(this.getMetadata(), null, null, frozenRealm, 3, null));
        }
        return managedRealmList;
    }

    @Override
    @Nullable
    public ManagedRealmList<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer == null) {
            managedRealmList = null;
        } else {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(it, ListOperatorMetadata.copy$default(this.getMetadata(), null, null, liveRealm, 3, null));
        }
        return managedRealmList;
    }

    @Override
    @NotNull
    public NativePointer registerForNotification(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_list_add_notification_callback(this.nativePointer, callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer change, @NotNull SendChannel<? super ManagedRealmList<E>> channel) {
        ChannelResult channelResult;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Observable frozenList = this.freeze(frozenRealm);
        if (frozenList != null) {
            channelResult = ChannelResult.box-impl((Object)channel.trySend-JP2dKIU((Object)frozenList));
        } else {
            SendChannel.DefaultImpls.close$default(channel, null, (int)1, null);
            channelResult = null;
        }
        return channelResult;
    }

    public final boolean isValid$library_base_release() {
        return RealmInterop.INSTANCE.realm_list_is_valid(this.nativePointer);
    }

    private final void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: '" + index + "', Size: '" + this.size() + '\'');
        }
    }
}

