/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.MutableRealm;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.internal.BaseRealmImpl;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.Observable;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmInterop;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u001b\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\r\u0010\f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\t\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J9\u0010\u001a\u001a\u00020\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u001d0\u001fH\u0010\u00a2\u0006\u0002\b J1\u0010!\u001a\u00020\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u0002H\u000f2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000f0\u001fH\u0010\u00a2\u0006\u0004\b\"\u0010#J'\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u000f0%\"\u0004\b\u0000\u0010\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u000f0'H\u0010\u00a2\u0006\u0002\b(J9\u0010)\u001a\u00020\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u000f0+2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0+0\u001fH\u0010\u00a2\u0006\u0002\b,\u00a8\u0006."}, d2={"Lio/realm/internal/MutableRealmImpl;", "Lio/realm/internal/BaseRealmImpl;", "Lio/realm/MutableRealm;", "configuration", "Lio/realm/internal/InternalConfiguration;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/realm/internal/InternalConfiguration;Lkotlinx/coroutines/CoroutineDispatcher;)V", "beginTransaction", "", "beginTransaction$library_base_release", "cancelWrite", "commitTransaction", "commitTransaction$library_base_release", "copyToRealm", "T", "Lio/realm/RealmObject;", "instance", "(Lio/realm/RealmObject;)Lio/realm/RealmObject;", "delete", "obj", "(Lio/realm/RealmObject;)V", "findLatest", "isInTransaction", "", "isInTransaction$library_base_release", "registerListChangeListener", "Lio/realm/Cancellable;", "list", "", "callback", "Lio/realm/Callback;", "registerListChangeListener$library_base_release", "registerObjectChangeListener", "registerObjectChangeListener$library_base_release", "(Lio/realm/RealmObject;Lio/realm/Callback;)Lio/realm/Cancellable;", "registerObserver", "Lkotlinx/coroutines/flow/Flow;", "t", "Lio/realm/internal/Observable;", "registerObserver$library_base_release", "registerResultsChangeListener", "results", "Lio/realm/internal/RealmResultsImpl;", "registerResultsChangeListener$library_base_release", "Companion", "library-base_release"})
public final class MutableRealmImpl
extends BaseRealmImpl
implements MutableRealm {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MutableRealmImpl(@NotNull InternalConfiguration configuration, @Nullable CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration, RealmInterop.INSTANCE.realm_open(configuration.getNativeConfig(), dispatcher));
    }

    public /* synthetic */ MutableRealmImpl(InternalConfiguration internalConfiguration, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = null;
        }
        this(internalConfiguration, coroutineDispatcher);
    }

    public final void beginTransaction$library_base_release() {
        try {
            RealmInterop.INSTANCE.realm_begin_write(this.getRealmReference$library_base_release().getDbPointer());
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Cannot begin the write transaction", exception);
        }
    }

    public final void commitTransaction$library_base_release() {
        RealmInterop.INSTANCE.realm_commit(this.getRealmReference$library_base_release().getDbPointer());
    }

    public final boolean isInTransaction$library_base_release() {
        return RealmInterop.INSTANCE.realm_is_in_transaction(this.getRealmReference$library_base_release().getDbPointer());
    }

    @Override
    @Nullable
    public <T extends RealmObject> T findLatest(@NotNull T obj) {
        RealmObject realmObject;
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        if (!RealmObjectKt.isValid(obj)) {
            realmObject = null;
        } else {
            if (!RealmObjectKt.isManaged(obj)) {
                throw new IllegalArgumentException("Unmanaged objects must be part of the Realm, before they can be queried this way. Use `MutableRealm.copyToRealm()` to turn it into a managed object.");
            }
            if (!RealmObjectKt.isFrozen(obj)) {
                realmObject = obj;
            } else {
                BaseRealmImpl liveRealm = this.getRealmReference$library_base_release().getOwner();
                realmObject = RealmObjectUtilKt.thaw((RealmObjectInternal)obj, liveRealm);
            }
        }
        return (T)realmObject;
    }

    @Override
    public void cancelWrite() {
        try {
            RealmInterop.INSTANCE.realm_rollback(this.getRealmReference$library_base_release().getDbPointer());
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Cannot cancel the write transaction", exception);
        }
    }

    @Override
    @NotNull
    public <T extends RealmObject> T copyToRealm(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        return (T)((RealmObject)RealmUtilsKt.copyToRealm$default(this.getConfiguration().getMediator(), this.getRealmReference$library_base_release(), instance, null, 8, null));
    }

    @Override
    public <T extends RealmObject> void delete(@NotNull T obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        RealmObjectInternal internalObject = (RealmObjectInternal)obj;
        MutableRealmImpl.Companion.checkObjectValid(internalObject);
        NativePointer nativePointer = internalObject.get$realm$ObjectPointer();
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            RealmInterop.INSTANCE.realm_object_delete(it);
        }
    }

    @Override
    @NotNull
    public <T> Flow<T> registerObserver$library_base_release(@NotNull Observable<T> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$library_base_release(@NotNull RealmResultsImpl<T> results, @NotNull Callback<RealmResultsImpl<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$library_base_release(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Override
    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$library_base_release(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J!\u0010\u0007\u001a\u00020\u0004\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\u0005\u001a\u0002H\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/realm/internal/MutableRealmImpl$Companion;", "", "()V", "checkObjectValid", "", "obj", "Lio/realm/internal/RealmObjectInternal;", "delete", "T", "Lio/realm/RealmObject;", "delete$library_base_release", "(Lio/realm/RealmObject;)V", "library-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public final <T extends RealmObject> void delete$library_base_release(@NotNull T obj) {
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            RealmObjectInternal internalObject = (RealmObjectInternal)obj;
            this.checkObjectValid(internalObject);
            NativePointer nativePointer = internalObject.get$realm$ObjectPointer();
            if (nativePointer != null) {
                NativePointer it = nativePointer;
                boolean bl = false;
                RealmInterop.INSTANCE.realm_object_delete(it);
            }
        }

        private final void checkObjectValid(RealmObjectInternal obj) {
            if (!RealmObjectKt.isValid(obj)) {
                throw new IllegalArgumentException("Cannot perform this operation on an invalid/deleted object");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

