/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.MutableRealmImpl;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmReference;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0002\u001a\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u0002*\u0002H\n\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u00a8\u0006\u000e"}, d2={"checkNotificationsAvailable", "", "Lio/realm/RealmObject;", "delete", "isFrozen", "", "isManaged", "isValid", "observe", "Lkotlinx/coroutines/flow/Flow;", "T", "(Lio/realm/RealmObject;)Lkotlinx/coroutines/flow/Flow;", "version", "Lio/realm/VersionId;", "io.realm.kotlin.library"})
public final class RealmObjectKt {
    public static final boolean isFrozen(@NotNull RealmObject $this$isFrozen) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrozen, (String)"<this>");
        RealmObject $this$realmObjectInternal$iv = $this$isFrozen;
        boolean $i$f$realmObjectInternal = false;
        return ((RealmObjectInternal)$this$realmObjectInternal$iv).isFrozen();
    }

    @NotNull
    public static final VersionId version(@NotNull RealmObject $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        RealmObject $this$realmObjectInternal$iv = $this$version;
        boolean $i$f$realmObjectInternal = false;
        return ((RealmObjectInternal)$this$realmObjectInternal$iv).version();
    }

    public static final void delete(@NotNull RealmObject $this$delete) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        MutableRealmImpl.Companion.delete$io_realm_kotlin_library($this$delete);
    }

    public static final boolean isManaged(@NotNull RealmObject $this$isManaged) {
        Intrinsics.checkNotNullParameter((Object)$this$isManaged, (String)"<this>");
        RealmObject $this$realmObjectInternal$iv = $this$isManaged;
        boolean $i$f$realmObjectInternal = false;
        return ((RealmObjectInternal)$this$realmObjectInternal$iv).get$realm$IsManaged();
    }

    public static final boolean isValid(@NotNull RealmObject $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        if (RealmObjectKt.isManaged($this$isValid)) {
            RealmObjectInternal internalObject = (RealmObjectInternal)$this$isValid;
            NativePointer ptr = internalObject.get$realm$ObjectPointer();
            return ptr != null ? RealmInterop.INSTANCE.realm_object_is_valid(ptr) : false;
        }
        return true;
    }

    @NotNull
    public static final <T extends RealmObject> Flow<T> observe(@NotNull T $this$observe) {
        Intrinsics.checkNotNullParameter($this$observe, (String)"<this>");
        RealmObjectKt.checkNotificationsAvailable($this$observe);
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$observe;
        RealmReference realmReference = internalObject.get$realm$Owner();
        Intrinsics.checkNotNull((Object)realmReference);
        return realmReference.getOwner().registerObserver$io_realm_kotlin_library((Thawable)((Object)$this$observe));
    }

    private static final void checkNotificationsAvailable(RealmObject $this$checkNotificationsAvailable) {
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$checkNotificationsAvailable;
        RealmReference realm = internalObject.get$realm$Owner();
        if (!RealmObjectKt.isManaged($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on unmanaged objects.");
        }
        if (realm != null && RealmInterop.INSTANCE.realm_is_closed(realm.getDbPointer())) {
            throw new IllegalStateException("Changes cannot be observed when the Realm has been closed.");
        }
        if (!RealmObjectKt.isValid($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on objects that have been deleted from the Realm.");
        }
    }
}

