/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.BaseRealm;
import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.RealmLog;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmState;
import io.realm.internal.RealmStateHolder;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.query.ObjectQuery;
import io.realm.internal.schema.RealmSchemaImpl;
import io.realm.query.RealmQuery;
import io.realm.schema.RealmSchema;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016JK\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!2\u0006\u0010\u001c\u001a\u00020\"2\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010%0$\"\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0016J9\u0010)\u001a\u00020*\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001e0,2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0,0.H\u0010\u00a2\u0006\u0002\b/J1\u00100\u001a\u00020*\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u00101\u001a\u0002H\u001e2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0.H\u0010\u00a2\u0006\u0004\b2\u00103J'\u00104\u001a\b\u0012\u0004\u0012\u0002H\u001e05\"\u0004\b\u0000\u0010\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001e07H\u0010\u00a2\u0006\u0002\b8J9\u00109\u001a\u00020*\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H\u001e0;2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0;0.H\u0010\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u00020>H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006@"}, d2={"Lio/realm/internal/BaseRealmImpl;", "Lio/realm/BaseRealm;", "Lio/realm/internal/RealmStateHolder;", "configuration", "Lio/realm/internal/InternalConfiguration;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/InternalConfiguration;Lio/realm/internal/interop/NativePointer;)V", "getConfiguration", "()Lio/realm/internal/InternalConfiguration;", "log", "Lio/realm/internal/RealmLog;", "getLog$io_realm_kotlin_library", "()Lio/realm/internal/RealmLog;", "<anonymous parameter 0>", "Lio/realm/internal/RealmReference;", "realmReference", "getRealmReference$io_realm_kotlin_library", "()Lio/realm/internal/RealmReference;", "setRealmReference$io_realm_kotlin_library", "(Lio/realm/internal/RealmReference;)V", "close", "", "close$io_realm_kotlin_library", "getNumberOfActiveVersions", "", "isClosed", "", "query", "Lio/realm/query/RealmQuery;", "T", "Lio/realm/RealmObject;", "clazz", "Lkotlin/reflect/KClass;", "", "args", "", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/query/RealmQuery;", "realmState", "Lio/realm/internal/RealmState;", "registerListChangeListener", "Lio/realm/Cancellable;", "list", "", "callback", "Lio/realm/Callback;", "registerListChangeListener$io_realm_kotlin_library", "registerObjectChangeListener", "obj", "registerObjectChangeListener$io_realm_kotlin_library", "(Lio/realm/RealmObject;Lio/realm/Callback;)Lio/realm/Cancellable;", "registerObserver", "Lkotlinx/coroutines/flow/Flow;", "t", "Lio/realm/internal/Thawable;", "registerObserver$io_realm_kotlin_library", "registerResultsChangeListener", "results", "Lio/realm/internal/RealmResultsImpl;", "registerResultsChangeListener$io_realm_kotlin_library", "schema", "Lio/realm/schema/RealmSchema;", "Companion", "io.realm.kotlin.library"})
public abstract class BaseRealmImpl
implements BaseRealm,
RealmStateHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalConfiguration configuration;
    @NotNull
    private RealmReference realmReference;
    @NotNull
    private final RealmLog log;
    @Deprecated
    @NotNull
    private static final String OBSERVABLE_NOT_SUPPORTED_MESSAGE = "Observing changes are not supported by this Realm.";

    public BaseRealmImpl(@NotNull InternalConfiguration configuration, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.configuration = configuration;
        this.realmReference = new RealmReference(this, dbPointer);
        this.log = new RealmLog(null, this.configuration.getLog(), 1, null);
        this.log.info(Intrinsics.stringPlus((String)"Realm opened: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Override
    @NotNull
    public final InternalConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public RealmReference getRealmReference$io_realm_kotlin_library() {
        return this.realmReference;
    }

    public void setRealmReference$io_realm_kotlin_library(@NotNull RealmReference $noName_0) {
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        throw new UnsupportedOperationException("BaseRealm reference should never be updated");
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.getRealmReference$io_realm_kotlin_library();
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @NotNull
    public final RealmLog getLog$io_realm_kotlin_library() {
        return this.log;
    }

    @Override
    @NotNull
    public RealmSchema schema() {
        return RealmSchemaImpl.Companion.fromRealm(this.getRealmReference$io_realm_kotlin_library());
    }

    @NotNull
    public <T extends RealmObject> RealmQuery<T> query(@NotNull KClass<T> clazz, @NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectQuery<T>(this.getRealmReference$io_realm_kotlin_library(), clazz, this.configuration.getMediator(), null, query2, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public <T> Flow<T> registerObserver$io_realm_kotlin_library(@NotNull Thawable<T> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$io_realm_kotlin_library(@NotNull RealmResultsImpl<T> results, @NotNull Callback<RealmResultsImpl<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$io_realm_kotlin_library(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$io_realm_kotlin_library(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public long getNumberOfActiveVersions() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$io_realm_kotlin_library();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return RealmInterop.INSTANCE.realm_get_num_versions(reference.getDbPointer());
    }

    public void close$io_realm_kotlin_library() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$io_realm_kotlin_library();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        RealmInterop.INSTANCE.realm_close(reference.getDbPointer());
        this.log.info(Intrinsics.stringPlus((String)"Realm closed: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/BaseRealmImpl$Companion;", "", "()V", "OBSERVABLE_NOT_SUPPORTED_MESSAGE", "", "io.realm.kotlin.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

