/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.LogConfiguration;
import io.realm.RealmObject;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.interop.SchemaMode;
import io.realm.internal.platform.RealmObjectKt;
import io.realm.internal.platform.SystemUtilsAndroidKt;
import io.realm.internal.schema.RealmClassImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001Bg\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR(\u0010\u001b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010'R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0010\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010!R\u0014\u0010\u000f\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010-\u00a8\u00065"}, d2={"Lio/realm/internal/ConfigurationImpl;", "Lio/realm/internal/InternalConfiguration;", "path", "", "name", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "logConfig", "Lio/realm/LogConfiguration;", "maxNumberOfActiveVersions", "", "notificationDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "writeDispatcher", "schemaVersion", "schemaMode", "Lio/realm/internal/interop/SchemaMode;", "encryptionKey", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lio/realm/LogConfiguration;JLkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;JLio/realm/internal/interop/SchemaMode;[B)V", "getEncryptionKey", "()[B", "log", "getLog", "()Lio/realm/LogConfiguration;", "mapOfKClassWithCompanion", "", "Lio/realm/internal/RealmObjectCompanion;", "getMapOfKClassWithCompanion", "()Ljava/util/Map;", "getMaxNumberOfActiveVersions", "()J", "mediator", "Lio/realm/internal/Mediator;", "getMediator", "()Lio/realm/internal/Mediator;", "getName", "()Ljava/lang/String;", "nativeConfig", "Lio/realm/internal/interop/NativePointer;", "getNativeConfig", "()Lio/realm/internal/interop/NativePointer;", "getNotificationDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "getPath", "getSchema", "()Ljava/util/Set;", "getSchemaMode", "()Lio/realm/internal/interop/SchemaMode;", "getSchemaVersion", "getWriteDispatcher", "io.realm.kotlin.library"})
public class ConfigurationImpl
implements InternalConfiguration {
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    @NotNull
    private final Set<KClass<? extends RealmObject>> schema;
    @NotNull
    private final LogConfiguration log;
    private final long maxNumberOfActiveVersions;
    private final long schemaVersion;
    @NotNull
    private final SchemaMode schemaMode;
    @NotNull
    private final Map<KClass<? extends RealmObject>, RealmObjectCompanion> mapOfKClassWithCompanion;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final NativePointer nativeConfig;
    @NotNull
    private final CoroutineDispatcher notificationDispatcher;
    @NotNull
    private final CoroutineDispatcher writeDispatcher;

    /*
     * WARNING - void declaration
     */
    public ConfigurationImpl(@Nullable String path, @NotNull String name, @NotNull Set<? extends KClass<? extends RealmObject>> schema, @NotNull LogConfiguration logConfig, long maxNumberOfActiveVersions, @NotNull CoroutineDispatcher notificationDispatcher, @NotNull CoroutineDispatcher writeDispatcher, long schemaVersion, @NotNull SchemaMode schemaMode, @Nullable byte[] encryptionKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        void $this$associateWith$iv;
        String string;
        Object directory;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Intrinsics.checkNotNullParameter((Object)notificationDispatcher, (String)"notificationDispatcher");
        Intrinsics.checkNotNullParameter((Object)writeDispatcher, (String)"writeDispatcher");
        Intrinsics.checkNotNullParameter((Object)schemaMode, (String)"schemaMode");
        this.nativeConfig = RealmInterop.INSTANCE.realm_config_new();
        if (path == null || ((CharSequence)path).length() == 0) {
            directory = SystemUtilsAndroidKt.appFilesDirectory();
            string = (String)directory + '/' + name;
        } else {
            string = path;
        }
        this.path = string;
        this.name = name;
        this.schema = schema;
        directory = schema;
        ConfigurationImpl configurationImpl = this;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            KClass kClass = (KClass)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            RealmObjectCompanion realmObjectCompanion = RealmObjectKt.realmObjectCompanion(it);
            object.put(t, realmObjectCompanion);
        }
        configurationImpl.mapOfKClassWithCompanion = result$iv;
        this.log = logConfig;
        this.maxNumberOfActiveVersions = maxNumberOfActiveVersions;
        this.notificationDispatcher = notificationDispatcher;
        this.writeDispatcher = writeDispatcher;
        this.schemaVersion = schemaVersion;
        this.schemaMode = schemaMode;
        RealmInterop.INSTANCE.realm_config_set_path(this.getNativeConfig(), this.getPath());
        RealmInterop.INSTANCE.realm_config_set_schema_mode(this.getNativeConfig(), schemaMode);
        RealmInterop.INSTANCE.realm_config_set_schema_version(this.getNativeConfig(), schemaVersion);
        Iterable $i$f$associateWith22 = this.getMapOfKClassWithCompanion().values();
        configurationImpl = RealmInterop.INSTANCE;
        boolean $i$f$map = false;
        $this$associateWithTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RealmObjectCompanion bl = (RealmObjectCompanion)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            RealmClassImpl it2 = it.$realm$schema();
            boolean bl3 = false;
            object.add(TuplesKt.to((Object)it2.getCinteropClass(), it2.getCinteropProperties()));
        }
        NativePointer nativeSchema = configurationImpl.realm_schema_new((List)destination$iv$iv);
        RealmInterop.INSTANCE.realm_config_set_schema(this.getNativeConfig(), nativeSchema);
        RealmInterop.INSTANCE.realm_config_set_max_number_of_active_versions(this.getNativeConfig(), maxNumberOfActiveVersions);
        if (encryptionKey != null) {
            byte[] it = encryptionKey;
            boolean bl = false;
            RealmInterop.INSTANCE.realm_config_set_encryption_key(this.getNativeConfig(), it);
        }
        this.mediator = new Mediator(){

            @Override
            @NotNull
            public RealmObjectInternal createInstanceOf(@NotNull KClass<?> clazz) {
                Object object;
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                RealmObjectCompanion realmObjectCompanion = this.getMapOfKClassWithCompanion().get(clazz);
                Object object2 = object = realmObjectCompanion == null ? null : realmObjectCompanion.$realm$newInstance();
                if (object == null) {
                    String string = clazz + " not part of this configuration schema";
                    throw new IllegalStateException(string.toString());
                }
                return (RealmObjectInternal)object;
            }

            @Override
            @NotNull
            public RealmObjectCompanion companionOf(@NotNull KClass<? extends RealmObject> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                RealmObjectCompanion realmObjectCompanion = this.getMapOfKClassWithCompanion().get(clazz);
                if (realmObjectCompanion == null) {
                    throw new IllegalStateException((clazz + " not part of this configuration schema").toString());
                }
                return realmObjectCompanion;
            }
        };
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Set<KClass<? extends RealmObject>> getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public LogConfiguration getLog() {
        return this.log;
    }

    @Override
    public long getMaxNumberOfActiveVersions() {
        return this.maxNumberOfActiveVersions;
    }

    @Override
    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    @NotNull
    public SchemaMode getSchemaMode() {
        return this.schemaMode;
    }

    @Override
    @Nullable
    public byte[] getEncryptionKey() {
        return RealmInterop.INSTANCE.realm_config_get_encryption_key(this.getNativeConfig());
    }

    @Override
    @NotNull
    public Map<KClass<? extends RealmObject>, RealmObjectCompanion> getMapOfKClassWithCompanion() {
        return this.mapOfKClassWithCompanion;
    }

    @Override
    @NotNull
    public Mediator getMediator() {
        return this.mediator;
    }

    @Override
    @NotNull
    public NativePointer getNativeConfig() {
        return this.nativeConfig;
    }

    @Override
    @NotNull
    public CoroutineDispatcher getNotificationDispatcher() {
        return this.notificationDispatcher;
    }

    @Override
    @NotNull
    public CoroutineDispatcher getWriteDispatcher() {
        return this.writeDispatcher;
    }

    @Override
    @NotNull
    public String debug() {
        return InternalConfiguration.DefaultImpls.debug(this);
    }
}

