/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.ChangeFlow;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.LiveRealm;
import io.realm.kotlin.internal.Mediator;
import io.realm.kotlin.internal.Notifiable;
import io.realm.kotlin.internal.ObjectChangeFlow;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmState;
import io.realm.kotlin.internal.RealmStateHolder;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.PropertyKey;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.interop.RealmObjectInterop;
import io.realm.kotlin.internal.interop.RealmObjectT;
import io.realm.kotlin.internal.interop.RealmT;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.notifications.ObjectChange;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 H*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u0006:\u0001HB=\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070$H\u0016J4\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070&2\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070(H\u0016J\r\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020*H\u0016J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010.\u001a\u00020\rH\u0016J'\u0010/\u001a\b\u0012\u0004\u0012\u00020\t002\u0010\u00101\u001a\f\u0012\u0004\u0012\u0002020\u0011j\u0002`3H\u0000\u00a2\u0006\u0004\b4\u00105J\r\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b8J<\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00132\u0010\b\u0002\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bH\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\tJ\b\u0010?\u001a\u00020@H\u0016J*\u0010A\u001a\f\u0012\u0004\u0012\u00020B0\u0011j\u0002`C2\u0016\u0010D\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002020\u0011j\u0002`30EH\u0016J\u0018\u0010F\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010G\u001a\u00020\rH\u0016J&\u0010F\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010G\u001a\u00020\r2\u000e\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006I"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference;", "T", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/internal/RealmStateHolder;", "Lio/realm/kotlin/internal/interop/RealmObjectInterop;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/CoreNotifiable;", "Lio/realm/kotlin/notifications/ObjectChange;", "className", "", "type", "Lkotlin/reflect/KClass;", "owner", "Lio/realm/kotlin/internal/RealmReference;", "mediator", "Lio/realm/kotlin/internal/Mediator;", "objectPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmObjectT;", "Lio/realm/kotlin/internal/interop/RealmObjectPointer;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Lio/realm/kotlin/internal/RealmReference;Lio/realm/kotlin/internal/Mediator;Lio/realm/kotlin/internal/interop/NativePointer;)V", "getClassName", "()Ljava/lang/String;", "getMediator", "()Lio/realm/kotlin/internal/Mediator;", "metadata", "Lio/realm/kotlin/internal/schema/ClassMetadata;", "getMetadata", "()Lio/realm/kotlin/internal/schema/ClassMetadata;", "getObjectPointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOwner", "()Lio/realm/kotlin/internal/RealmReference;", "getType", "()Lkotlin/reflect/KClass;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "changeFlow", "Lio/realm/kotlin/internal/ChangeFlow;", "scope", "Lkotlinx/coroutines/channels/ProducerScope;", "checkValid", "", "checkValid$io_realm_kotlin_library", "delete", "freeze", "frozenRealm", "getChangedFieldNames", "", "change", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "getChangedFieldNames$io_realm_kotlin_library", "(Lio/realm/kotlin/internal/interop/NativePointer;)[Ljava/lang/String;", "isValid", "", "isValid$io_realm_kotlin_library", "newObjectReference", "pointer", "clazz", "propertyInfoOrThrow", "Lio/realm/kotlin/internal/schema/PropertyMetadata;", "propertyName", "realmState", "Lio/realm/kotlin/internal/RealmState;", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "thaw", "liveRealm", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmObjectReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmObjectReference.kt\nio/realm/kotlin/internal/RealmObjectReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1549#2:193\n1620#2,3:194\n37#3,2:197\n1#4:199\n*S KotlinDebug\n*F\n+ 1 RealmObjectReference.kt\nio/realm/kotlin/internal/RealmObjectReference\n*L\n122#1:193\n122#1:194,3\n124#1:197,2\n*E\n"})
public final class RealmObjectReference<T extends BaseRealmObject>
implements RealmStateHolder,
RealmObjectInterop,
InternalDeleteable,
CoreNotifiable<RealmObjectReference<T>, ObjectChange<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String className;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final RealmReference owner;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final NativePointer<RealmObjectT> objectPointer;
    @NotNull
    private final ClassMetadata metadata;
    @NotNull
    public static final String INVALID_OBJECT_MSG = "Cannot perform this operation on an invalid/deleted object";

    public RealmObjectReference(@NotNull String className, @NotNull KClass<T> type, @NotNull RealmReference owner, @NotNull Mediator mediator, @NotNull NativePointer<RealmObjectT> objectPointer) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(objectPointer, (String)"objectPointer");
        this.className = className;
        this.type = type;
        this.owner = owner;
        this.mediator = mediator;
        this.objectPointer = objectPointer;
        ClassMetadata classMetadata = this.owner.getSchemaMetadata().get(this.className);
        Intrinsics.checkNotNull((Object)classMetadata);
        this.metadata = classMetadata;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    @NotNull
    public final RealmReference getOwner() {
        return this.owner;
    }

    @NotNull
    public final Mediator getMediator() {
        return this.mediator;
    }

    @NotNull
    public NativePointer<RealmObjectT> getObjectPointer() {
        return this.objectPointer;
    }

    @NotNull
    public final ClassMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final PropertyMetadata propertyInfoOrThrow(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.metadata.getOrThrow(propertyName);
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.owner;
    }

    private final RealmObjectReference<? extends BaseRealmObject> newObjectReference(RealmReference owner, NativePointer<RealmObjectT> pointer, KClass<? extends BaseRealmObject> clazz) {
        Mediator mediator = this.mediator;
        String string = this.className;
        return new RealmObjectReference<BaseRealmObject>(string, clazz, owner, mediator, pointer);
    }

    static /* synthetic */ RealmObjectReference newObjectReference$default(RealmObjectReference realmObjectReference, RealmReference realmReference2, NativePointer nativePointer, KClass kClass, int n, Object object) {
        if ((n & 4) != 0) {
            kClass = realmObjectReference.type;
        }
        return realmObjectReference.newObjectReference(realmReference2, (NativePointer<RealmObjectT>)nativePointer, kClass);
    }

    @Override
    @Nullable
    public RealmObjectReference<T> freeze(@NotNull RealmReference frozenRealm) {
        RealmObjectReference realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = RealmObjectReference.newObjectReference$default(this, frozenRealm, pointer, null, 4, null);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @Nullable
    public RealmObjectReference<T> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return this.thaw(liveRealm, this.type);
    }

    @Nullable
    public final RealmObjectReference<T> thaw(@NotNull RealmReference liveRealm, @NotNull KClass<? extends BaseRealmObject> clazz) {
        RealmObjectReference<BaseRealmObject> realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        NativePointer<? extends RealmT> dbPointer = liveRealm.getDbPointer();
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), dbPointer);
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = this.newObjectReference(liveRealm, (NativePointer<RealmObjectT>)pointer, clazz);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_object_add_notification_callback(this.getObjectPointer(), callback);
    }

    @Override
    @NotNull
    public ChangeFlow<RealmObjectReference<T>, ObjectChange<T>> changeFlow(@NotNull ProducerScope<? super ObjectChange<T>> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        return new ObjectChangeFlow(scope);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getChangedFieldNames$io_realm_kotlin_library(@NotNull NativePointer<RealmChangesT> change) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(change, (String)"change");
        Iterable $this$map$iv = RealmInterop.INSTANCE.realm_object_changes_get_modified_properties(change);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void propertyKey;
            long l = ((PropertyKey)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.metadata.get-XxIY2SY((long)propertyKey);
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public Flow<ObjectChange<T>> asFlow() {
        return this.owner.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    public void delete() {
        if (this.isFrozen()) {
            throw new IllegalArgumentException("Frozen objects cannot be deleted. They must be converted to live objects first by using `MutableRealm/DynamicMutableRealm.findLatest(frozenObject)`.");
        }
        if (!this.isValid$io_realm_kotlin_library()) {
            throw new IllegalArgumentException(INVALID_OBJECT_MSG);
        }
        NativePointer<RealmObjectT> it = this.getObjectPointer();
        boolean bl = false;
        RealmInterop.INSTANCE.realm_object_delete(it);
    }

    public final boolean isValid$io_realm_kotlin_library() {
        NativePointer<RealmObjectT> ptr = this.getObjectPointer();
        return ptr != null ? !ptr.isReleased() && RealmInterop.INSTANCE.realm_object_is_valid(ptr) : false;
    }

    public final void checkValid$io_realm_kotlin_library() {
        if (!this.isValid$io_realm_kotlin_library()) {
            throw new IllegalStateException(INVALID_OBJECT_MSG);
        }
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @Override
    @NotNull
    public Notifiable<RealmObjectReference<T>, ObjectChange<T>> notifiable() {
        return CoreNotifiable.DefaultImpls.notifiable(this);
    }

    @Override
    @Nullable
    public CoreNotifiable<RealmObjectReference<T>, ObjectChange<T>> coreObservable(@NotNull LiveRealm liveRealm) {
        return CoreNotifiable.DefaultImpls.coreObservable(this, liveRealm);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference$Companion;", "", "()V", "INVALID_OBJECT_MSG", "", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

