/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.FrozenRealmReference;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.NotificationToken;
import io.realm.kotlin.internal.RealmImpl;
import io.realm.kotlin.internal.VersionData;
import io.realm.kotlin.internal.VersionTracker;
import io.realm.kotlin.internal.interop.CapiT;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSchemaT;
import io.realm.kotlin.internal.interop.SynchronizableObject;
import io.realm.kotlin.internal.platform.CoroutineUtilsSharedJvmKt;
import io.realm.kotlin.internal.util.LiveRealmContext;
import java.lang.ref.WeakReference;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u00018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010#\u001a\u00020$H\u0010\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020$H\u0010\u00a2\u0006\u0002\b)J\u001a\u0010*\u001a\u00020$2\u0010\u0010+\u001a\f\u0012\u0004\u0012\u00020-0,j\u0002`.H\u0014J\r\u0010/\u001a\u00020$H\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020$H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020$H\u0000\u00a2\u0006\u0002\b4J\r\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00069"}, d2={"Lio/realm/kotlin/internal/LiveRealm;", "Lio/realm/kotlin/internal/BaseRealmImpl;", "owner", "Lio/realm/kotlin/internal/RealmImpl;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "scheduler", "Lio/realm/kotlin/internal/util/LiveRealmContext;", "(Lio/realm/kotlin/internal/RealmImpl;Lio/realm/kotlin/internal/InternalConfiguration;Lio/realm/kotlin/internal/util/LiveRealmContext;)V", "_closeSnapshotWhenAdvancing", "", "_snapshot", "Lkotlinx/atomicfu/AtomicRef;", "Lio/realm/kotlin/internal/FrozenRealmReference;", "getOwner", "()Lio/realm/kotlin/internal/RealmImpl;", "realmChangeRegistration", "Lio/realm/kotlin/internal/NotificationToken;", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "realmReference$delegate", "Lkotlin/Lazy;", "schemaChangeRegistration", "snapshotLock", "Lio/realm/kotlin/internal/interop/SynchronizableObject;", "snapshotVersion", "Lio/realm/kotlin/VersionId;", "getSnapshotVersion$io_realm_kotlin_library", "()Lio/realm/kotlin/VersionId;", "versionTracker", "Lio/realm/kotlin/internal/VersionTracker;", "getVersionTracker$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/VersionTracker;", "close", "", "close$io_realm_kotlin_library", "gcTrackedSnapshot", "gcTrackedSnapshot$io_realm_kotlin_library", "onRealmChanged", "onRealmChanged$io_realm_kotlin_library", "onSchemaChanged", "schema", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSchemaT;", "Lio/realm/kotlin/internal/interop/RealmSchemaPointer;", "refresh", "refresh$io_realm_kotlin_library", "unregisterCallbacks", "unregisterCallbacks$io_realm_kotlin_library", "updateSnapshot", "updateSnapshot$io_realm_kotlin_library", "versions", "Lio/realm/kotlin/internal/VersionData;", "versions$io_realm_kotlin_library", "WeakLiveRealmCallback", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nLiveRealm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveRealm.kt\nio/realm/kotlin/internal/LiveRealm\n+ 2 SynchronizableObject.kt\nio/realm/kotlin/internal/interop/SynchronizableObject\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n20#2:193\n20#2:195\n1#3:194\n1#3:196\n*S KotlinDebug\n*F\n+ 1 LiveRealm.kt\nio/realm/kotlin/internal/LiveRealm\n*L\n100#1:193\n123#1:195\n100#1:194\n123#1:196\n*E\n"})
public abstract class LiveRealm
extends BaseRealmImpl {
    @NotNull
    private final RealmImpl owner;
    @NotNull
    private final LiveRealmContext scheduler;
    @NotNull
    private final NotificationToken realmChangeRegistration;
    @NotNull
    private final NotificationToken schemaChangeRegistration;
    @NotNull
    private final VersionTracker versionTracker;
    @NotNull
    private final Lazy realmReference$delegate;
    @NotNull
    private final AtomicRef<FrozenRealmReference> _snapshot;
    private boolean _closeSnapshotWhenAdvancing;
    @NotNull
    private final SynchronizableObject snapshotLock;

    public LiveRealm(@NotNull RealmImpl owner, @NotNull InternalConfiguration configuration, @NotNull LiveRealmContext scheduler2) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)scheduler2, (String)"scheduler");
        super(configuration);
        this.owner = owner;
        this.scheduler = scheduler2;
        this.versionTracker = new VersionTracker(this, this.owner.getLog$io_realm_kotlin_library());
        this.realmReference$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LiveRealmReference>(configuration, this){
            final /* synthetic */ InternalConfiguration $configuration;
            final /* synthetic */ LiveRealm this$0;
            {
                this.$configuration = $configuration;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LiveRealmReference invoke() {
                NativePointer dbPointer = (NativePointer)RealmInterop.INSTANCE.realm_open(this.$configuration.createNativeConfiguration(), LiveRealm.access$getScheduler$p(this.this$0).getScheduler()).component1();
                return new LiveRealmReference(this.this$0, (NativePointer<LiveRealmT>)dbPointer);
            }
        }));
        this._snapshot = AtomicFU.atomic((Object)this.getRealmReference().snapshot(this.owner));
        this._closeSnapshotWhenAdvancing = true;
        this.snapshotLock = new SynchronizableObject();
        WeakLiveRealmCallback callback = new WeakLiveRealmCallback(this);
        this.realmChangeRegistration = new NotificationToken((NativePointer<? extends CapiT>)RealmInterop.INSTANCE.realm_add_realm_changed_callback(this.getRealmReference().getDbPointer(), (Function0)new Function0<Unit>((Object)callback){

            public final void invoke() {
                ((WeakLiveRealmCallback)this.receiver).onRealmChanged();
            }
        }));
        this.schemaChangeRegistration = new NotificationToken((NativePointer<? extends CapiT>)RealmInterop.INSTANCE.realm_add_schema_changed_callback(this.getRealmReference().getDbPointer(), (Function1)new Function1<NativePointer<RealmSchemaT>, Unit>((Object)callback){

            public final void invoke(@NotNull NativePointer<RealmSchemaT> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((WeakLiveRealmCallback)this.receiver).onSchemaChanged(p0);
            }
        }));
    }

    @NotNull
    public final RealmImpl getOwner() {
        return this.owner;
    }

    @NotNull
    public final VersionTracker getVersionTracker$io_realm_kotlin_library() {
        return this.versionTracker;
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference() {
        Lazy lazy = this.realmReference$delegate;
        return (LiveRealmReference)lazy.getValue();
    }

    @NotNull
    public final VersionId getSnapshotVersion$io_realm_kotlin_library() {
        return ((FrozenRealmReference)this._snapshot.getValue()).uncheckedVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FrozenRealmReference gcTrackedSnapshot$io_realm_kotlin_library() {
        FrozenRealmReference frozenRealmReference;
        SynchronizableObject this_$iv = this.snapshotLock;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            boolean bl = false;
            boolean bl2 = false;
            Object object = this._snapshot.getValue();
            FrozenRealmReference snapshot = (FrozenRealmReference)object;
            boolean bl3 = false;
            if (this._closeSnapshotWhenAdvancing && !snapshot.isClosed()) {
                this.getLog$io_realm_kotlin_library().trace(this + " ENABLE-TRACKING " + snapshot.version(), new Object[0]);
                this._closeSnapshotWhenAdvancing = false;
            }
            frozenRealmReference = (FrozenRealmReference)object;
        }
        return frozenRealmReference;
    }

    public void onRealmChanged$io_realm_kotlin_library() {
        this.updateSnapshot$io_realm_kotlin_library();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateSnapshot$io_realm_kotlin_library() {
        SynchronizableObject this_$iv = this.snapshotLock;
        boolean $i$f$withLock = false;
        SynchronizableObject synchronizableObject = this_$iv;
        synchronized (synchronizableObject) {
            VersionId version;
            block9: {
                block8: {
                    boolean bl = false;
                    boolean bl2 = false;
                    version = ((FrozenRealmReference)this._snapshot.getValue()).version();
                    if (this.getRealmReference().isClosed()) break block8;
                    if (!Intrinsics.areEqual((Object)version, (Object)this.getRealmReference().version())) break block9;
                }
                return;
            }
            if (this._closeSnapshotWhenAdvancing) {
                this.getLog$io_realm_kotlin_library().trace(this + " CLOSE-UNTRACKED " + version, new Object[0]);
                ((FrozenRealmReference)this._snapshot.getValue()).close();
            } else {
                this.versionTracker.trackReference((FrozenRealmReference)this._snapshot.getValue());
            }
            this._snapshot.setValue((Object)this.getRealmReference().snapshot(this.owner));
            this.getLog$io_realm_kotlin_library().trace(this + " ADVANCING " + version + " -> " + ((FrozenRealmReference)this._snapshot.getValue()).version(), new Object[0]);
            this._closeSnapshotWhenAdvancing = true;
            Unit unit = Unit.INSTANCE;
        }
        this.versionTracker.closeExpiredReferences();
    }

    protected void onSchemaChanged(@NotNull NativePointer<RealmSchemaT> schema) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.getRealmReference().refreshSchemaMetadata();
    }

    public final void refresh$io_realm_kotlin_library() {
        RealmInterop.INSTANCE.realm_refresh(this.getRealmReference().getDbPointer());
    }

    public final void unregisterCallbacks$io_realm_kotlin_library() {
        this.realmChangeRegistration.cancel();
        this.schemaChangeRegistration.cancel();
    }

    @Override
    public void close$io_realm_kotlin_library() {
        this.getRealmReference().close();
        FrozenRealmReference it = (FrozenRealmReference)this._snapshot.getValue();
        boolean bl = false;
        this.getLog$io_realm_kotlin_library().trace(this + " CLOSE-ACTIVE " + it.version(), new Object[0]);
        it.close();
        this.versionTracker.close();
        this.unregisterCallbacks$io_realm_kotlin_library();
        super.close$io_realm_kotlin_library();
    }

    @NotNull
    public final VersionData versions$io_realm_kotlin_library() {
        return (VersionData)CoroutineUtilsSharedJvmKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super VersionData>, Object>(this, null){
            int label;
            final /* synthetic */ LiveRealm this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)LiveRealm.access$getScheduler$p(this.this$0).getDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VersionData>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ LiveRealm this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        VersionData versionData;
                                        void this_$iv;
                                        ResultKt.throwOnFailure((Object)object);
                                        SynchronizableObject synchronizableObject = LiveRealm.access$getSnapshotLock$p(this.this$0);
                                        LiveRealm liveRealm = this.this$0;
                                        boolean $i$f$withLock = false;
                                        void var5_5 = this_$iv;
                                        synchronized (var5_5) {
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            Set active = !LiveRealm.access$get_closeSnapshotWhenAdvancing$p(liveRealm) ? SetsKt.plus(liveRealm.getVersionTracker$io_realm_kotlin_library().versions(), (Object)((FrozenRealmReference)LiveRealm.access$get_snapshot$p(liveRealm).getValue()).version()) : liveRealm.getVersionTracker$io_realm_kotlin_library().versions();
                                            versionData = new VersionData(((FrozenRealmReference)LiveRealm.access$get_snapshot$p(liveRealm).getValue()).version(), active);
                                        }
                                        return versionData;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VersionData> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VersionData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public static final /* synthetic */ LiveRealmContext access$getScheduler$p(LiveRealm $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ SynchronizableObject access$getSnapshotLock$p(LiveRealm $this) {
        return $this.snapshotLock;
    }

    public static final /* synthetic */ boolean access$get_closeSnapshotWhenAdvancing$p(LiveRealm $this) {
        return $this._closeSnapshotWhenAdvancing;
    }

    public static final /* synthetic */ AtomicRef access$get_snapshot$p(LiveRealm $this) {
        return $this._snapshot;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/internal/LiveRealm$WeakLiveRealmCallback;", "", "liveRealm", "Lio/realm/kotlin/internal/LiveRealm;", "(Lio/realm/kotlin/internal/LiveRealm;)V", "realm", "Ljava/lang/ref/WeakReference;", "Lio/realm/kotlin/internal/platform/WeakReference;", "getRealm", "()Ljava/lang/ref/WeakReference;", "onRealmChanged", "", "onSchemaChanged", "schema", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSchemaT;", "Lio/realm/kotlin/internal/interop/RealmSchemaPointer;", "io.realm.kotlin.library"})
    private static final class WeakLiveRealmCallback {
        @NotNull
        private final WeakReference<LiveRealm> realm;

        public WeakLiveRealmCallback(@NotNull LiveRealm liveRealm) {
            Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
            this.realm = new WeakReference<LiveRealm>(liveRealm);
        }

        @NotNull
        public final WeakReference<LiveRealm> getRealm() {
            return this.realm;
        }

        public final void onRealmChanged() {
            block0: {
                LiveRealm liveRealm = (LiveRealm)this.realm.get();
                if (liveRealm == null) break block0;
                liveRealm.onRealmChanged$io_realm_kotlin_library();
            }
        }

        public final void onSchemaChanged(@NotNull NativePointer<RealmSchemaT> schema) {
            block0: {
                Intrinsics.checkNotNullParameter(schema, (String)"schema");
                LiveRealm liveRealm = (LiveRealm)this.realm.get();
                if (liveRealm == null) break block0;
                liveRealm.onSchemaChanged(schema);
            }
        }
    }
}

