/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.query;

import io.realm.kotlin.internal.ObjectBoundRealmResults;
import io.realm.kotlin.internal.ObjectBoundRealmResultsKt;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.query.ObjectBoundRealmScalarNullableQuery;
import io.realm.kotlin.internal.query.ObjectBoundRealmScalarQuery;
import io.realm.kotlin.internal.query.ObjectBoundRealmSingleQuery;
import io.realm.kotlin.notifications.ResultsChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.query.RealmScalarNullableQuery;
import io.realm.kotlin.query.RealmScalarQuery;
import io.realm.kotlin.query.RealmSingleQuery;
import io.realm.kotlin.query.Sort;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\t\u0010\u0015\u001a\u00020\u0011H\u0096\u0001J/\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0019\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\b\b\u0001\u0010#*\u00020$2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016J.\u0010'\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\b\b\u0001\u0010#*\u00020$2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016J3\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010)\u001a\u00020\u00112\u0016\u0010*\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0\u0019\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010+JS\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020/0.2*\u00100\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020/0.0\u0019\"\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020/0.H\u0016\u00a2\u0006\u0002\u00101J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u00102\u001a\u00020/H\u0016J.\u00103\u001a\b\u0012\u0004\u0012\u0002H#0\u0013\"\b\b\u0001\u0010#*\u00020$2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00064"}, d2={"Lio/realm/kotlin/internal/query/ObjectBoundQuery;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmQuery;", "targetObject", "Lio/realm/kotlin/internal/RealmObjectReference;", "realmQuery", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/query/RealmQuery;)V", "getRealmQuery", "()Lio/realm/kotlin/query/RealmQuery;", "getTargetObject", "()Lio/realm/kotlin/internal/RealmObjectReference;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/kotlin/notifications/ResultsChange;", "keyPaths", "", "", "count", "Lio/realm/kotlin/query/RealmScalarQuery;", "", "description", "distinct", "property", "extraProperties", "", "(Ljava/lang/String;[Ljava/lang/String;)Lio/realm/kotlin/query/RealmQuery;", "find", "Lio/realm/kotlin/query/RealmResults;", "first", "Lio/realm/kotlin/query/RealmSingleQuery;", "limit", "", "max", "Lio/realm/kotlin/query/RealmScalarNullableQuery;", "T", "", "type", "Lkotlin/reflect/KClass;", "min", "query", "filter", "arguments", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "sort", "propertyAndSortOrder", "Lkotlin/Pair;", "Lio/realm/kotlin/query/Sort;", "additionalPropertiesAndOrders", "(Lkotlin/Pair;[Lkotlin/Pair;)Lio/realm/kotlin/query/RealmQuery;", "sortOrder", "sum", "io.realm.kotlin.library"})
public final class ObjectBoundQuery<E extends BaseRealmObject>
implements RealmQuery<E> {
    @NotNull
    private final RealmObjectReference<?> targetObject;
    @NotNull
    private final RealmQuery<E> realmQuery;

    public ObjectBoundQuery(@NotNull RealmObjectReference<?> targetObject, @NotNull RealmQuery<E> realmQuery) {
        Intrinsics.checkNotNullParameter(targetObject, (String)"targetObject");
        Intrinsics.checkNotNullParameter(realmQuery, (String)"realmQuery");
        this.targetObject = targetObject;
        this.realmQuery = realmQuery;
    }

    @NotNull
    public final RealmObjectReference<?> getTargetObject() {
        return this.targetObject;
    }

    @NotNull
    public final RealmQuery<E> getRealmQuery() {
        return this.realmQuery;
    }

    @Override
    @NotNull
    public String description() {
        return this.realmQuery.description();
    }

    @Override
    @NotNull
    public RealmResults<E> find() {
        return new ObjectBoundRealmResults(this.targetObject, this.realmQuery.find());
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String filter, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmQuery.query(filter, Arrays.copyOf(arguments, arguments.length)));
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow(@Nullable List<String> keyPaths) {
        return ObjectBoundRealmResultsKt.bind(this.realmQuery.asFlow(keyPaths), this.targetObject);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull String property, @NotNull Sort sortOrder) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmQuery.sort(property, sortOrder));
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull Pair<String, ? extends Sort> propertyAndSortOrder, Pair<String, ? extends Sort> ... additionalPropertiesAndOrders) {
        Intrinsics.checkNotNullParameter(propertyAndSortOrder, (String)"propertyAndSortOrder");
        Intrinsics.checkNotNullParameter(additionalPropertiesAndOrders, (String)"additionalPropertiesAndOrders");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmQuery.sort(propertyAndSortOrder, Arrays.copyOf(additionalPropertiesAndOrders, additionalPropertiesAndOrders.length)));
    }

    @Override
    @NotNull
    public RealmQuery<E> distinct(@NotNull String property, String ... extraProperties) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)extraProperties, (String)"extraProperties");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmQuery.distinct(property, Arrays.copyOf(extraProperties, extraProperties.length)));
    }

    @Override
    @NotNull
    public RealmQuery<E> limit(int limit) {
        return new ObjectBoundQuery<E>(this.targetObject, this.realmQuery.limit(limit));
    }

    @Override
    @NotNull
    public RealmSingleQuery<E> first() {
        return new ObjectBoundRealmSingleQuery<E>(this.targetObject, this.realmQuery.first());
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> min(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ObjectBoundRealmScalarNullableQuery<E>(this.targetObject, this.realmQuery.min(property, type));
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> max(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ObjectBoundRealmScalarNullableQuery<E>(this.targetObject, this.realmQuery.max(property, type));
    }

    @Override
    @NotNull
    public <T> RealmScalarQuery<T> sum(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ObjectBoundRealmScalarQuery<E>(this.targetObject, this.realmQuery.sum(property, type));
    }

    @Override
    @NotNull
    public RealmScalarQuery<Long> count() {
        return new ObjectBoundRealmScalarQuery<Long>(this.targetObject, this.realmQuery.count());
    }
}

