/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.Versioned;
import io.realm.kotlin.internal.ChangeFlow;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.ListOperator;
import io.realm.kotlin.internal.LiveRealm;
import io.realm.kotlin.internal.Notifiable;
import io.realm.kotlin.internal.RealmListChangeFlow;
import io.realm.kotlin.internal.RealmListInternalKt;
import io.realm.kotlin.internal.RealmObjectListOperator;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.ClassKey;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmKeyPathArrayT;
import io.realm.kotlin.internal.interop.RealmListT;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.notifications.ListChange;
import io.realm.kotlin.types.RealmList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00052\u00020\u0007B1\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J$\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060%2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0016J4\u0010)\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060*2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060,H\u0016J\b\u0010-\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020\u001cH\u0016J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0018H\u0096\u0002\u00a2\u0006\u0002\u00103J\r\u00104\u001a\u00020!H\u0000\u00a2\u0006\u0002\b5J@\u00106\u001a\f\u0012\u0004\u0012\u0002070\u000bj\u0002`82\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u000209\u0018\u00010\u000bj\u0004\u0018\u0001`:2\u0016\u0010;\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020=0\u000bj\u0002`>0<H\u0016J\u0015\u0010?\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00103J\u001e\u0010@\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010AJ\u0018\u0010B\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010C\u001a\u000201H\u0016J\t\u0010D\u001a\u00020EH\u0096\u0001R\u001e\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006F"}, d2={"Lio/realm/kotlin/internal/ManagedRealmList;", "E", "Lkotlin/collections/AbstractMutableList;", "Lio/realm/kotlin/types/RealmList;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/CoreNotifiable;", "Lio/realm/kotlin/notifications/ListChange;", "Lio/realm/kotlin/Versioned;", "parent", "Lio/realm/kotlin/internal/RealmObjectReference;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmListT;", "Lio/realm/kotlin/internal/interop/RealmListPointer;", "operator", "Lio/realm/kotlin/internal/ListOperator;", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/ListOperator;)V", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOperator", "()Lio/realm/kotlin/internal/ListOperator;", "getParent$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/RealmObjectReference;", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "addAll", "", "elements", "", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "keyPaths", "", "", "changeFlow", "Lio/realm/kotlin/internal/ChangeFlow;", "scope", "Lkotlinx/coroutines/channels/ProducerScope;", "clear", "delete", "freeze", "frozenRealm", "Lio/realm/kotlin/internal/RealmReference;", "get", "(I)Ljava/lang/Object;", "isValid", "isValid$io_realm_kotlin_library", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayT;", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "thaw", "liveRealm", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmListInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmListInternal.kt\nio/realm/kotlin/internal/ManagedRealmList\n+ 2 Validation.kt\nio/realm/kotlin/internal/util/Validation\n*L\n1#1,460:1\n42#2,7:461\n*S KotlinDebug\n*F\n+ 1 RealmListInternal.kt\nio/realm/kotlin/internal/ManagedRealmList\n*L\n121#1:461,7\n*E\n"})
public final class ManagedRealmList<E>
extends AbstractMutableList<E>
implements RealmList<E>,
InternalDeleteable,
CoreNotifiable<ManagedRealmList<E>, ListChange<E>>,
Versioned {
    @NotNull
    private final RealmObjectReference<?> parent;
    @NotNull
    private final NativePointer<RealmListT> nativePointer;
    @NotNull
    private final ListOperator<E> operator;
    private final /* synthetic */ RealmReference $$delegate_0;

    public ManagedRealmList(@NotNull RealmObjectReference<?> parent2, @NotNull NativePointer<RealmListT> nativePointer, @NotNull ListOperator<E> operator) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.parent = parent2;
        this.nativePointer = nativePointer;
        this.operator = operator;
        this.$$delegate_0 = operator.getRealmReference();
    }

    @NotNull
    public final RealmObjectReference<?> getParent$io_realm_kotlin_library() {
        return this.parent;
    }

    @NotNull
    public final NativePointer<RealmListT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @NotNull
    public final ListOperator<E> getOperator() {
        return this.operator;
    }

    @Override
    @NotNull
    public VersionId version() {
        return this.$$delegate_0.version();
    }

    public int getSize() {
        this.operator.getRealmReference().checkClosed();
        return (int)RealmInterop.INSTANCE.realm_list_size(this.nativePointer);
    }

    @Override
    public E get(int index) {
        this.operator.getRealmReference().checkClosed();
        return this.operator.get(index);
    }

    @Override
    public void add(int index, E element) {
        ListOperator.DefaultImpls.insert$default(this.operator, index, element, null, null, 12, null);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return ListOperator.DefaultImpls.insertAll$default(this.operator, this.size(), elements, null, null, 12, null);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        RealmListInternalKt.access$checkPositionIndex(index, this.size());
        return ListOperator.DefaultImpls.insertAll$default(this.operator, index, elements, null, null, 12, null);
    }

    @Override
    public void clear() {
        this.operator.getRealmReference().checkClosed();
        RealmInterop.INSTANCE.realm_list_clear(this.nativePointer);
    }

    public E removeAt(int index) {
        E e;
        E it = e = this.get(index);
        boolean bl = false;
        this.operator.getRealmReference().checkClosed();
        RealmInterop.INSTANCE.realm_list_erase(this.nativePointer, (long)index);
        return e;
    }

    @Override
    public E set(int index, E element) {
        this.operator.getRealmReference().checkClosed();
        return (E)ListOperator.DefaultImpls.set$default(this.operator, index, element, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flow<ListChange<E>> asFlow(@Nullable List<String> keyPaths) {
        Pair pair;
        this.operator.getRealmReference().checkClosed();
        List<String> list = keyPaths;
        if (list != null) {
            void arg$iv;
            List<String> it = list;
            boolean bl = false;
            Validation validation = Validation.INSTANCE;
            ListOperator<E> listOperator = this.operator;
            String errorMessage$iv = "Keypaths are only supported for lists of objects.";
            boolean $i$f$isType = false;
            if (!(arg$iv instanceof RealmObjectListOperator)) {
                throw new IllegalArgumentException(errorMessage$iv);
            }
            pair = new Pair((Object)ClassKey.box-impl((long)((RealmObjectListOperator)this.operator).getClassKey-QNRHIEo()), keyPaths);
        } else {
            pair = null;
        }
        Pair keyPathInfo = pair;
        return this.operator.getRealmReference().getOwner().registerObserver$io_realm_kotlin_library(this, keyPathInfo);
    }

    @Override
    @Nullable
    public ManagedRealmList<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(this.parent, (NativePointer<RealmListT>)it, this.operator.copy(frozenRealm, (NativePointer<RealmListT>)it));
        } else {
            managedRealmList = null;
        }
        return managedRealmList;
    }

    @Override
    @Nullable
    public ManagedRealmList<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(this.parent, (NativePointer<RealmListT>)it, this.operator.copy(liveRealm, (NativePointer<RealmListT>)it));
        } else {
            managedRealmList = null;
        }
        return managedRealmList;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@Nullable NativePointer<RealmKeyPathArrayT> keyPaths, @NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_list_add_notification_callback(this.nativePointer, keyPaths, callback);
    }

    @Override
    @NotNull
    public ChangeFlow<ManagedRealmList<E>, ListChange<E>> changeFlow(@NotNull ProducerScope<? super ListChange<E>> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        return new RealmListChangeFlow(scope);
    }

    public final boolean isValid$io_realm_kotlin_library() {
        return !this.nativePointer.isReleased() && RealmInterop.INSTANCE.realm_list_is_valid(this.nativePointer);
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_list_remove_all(this.nativePointer);
    }

    @Override
    @NotNull
    public Notifiable<ManagedRealmList<E>, ListChange<E>> notifiable() {
        return CoreNotifiable.DefaultImpls.notifiable(this);
    }

    @Override
    @Nullable
    public CoreNotifiable<ManagedRealmList<E>, ListChange<E>> coreObservable(@NotNull LiveRealm liveRealm) {
        return CoreNotifiable.DefaultImpls.coreObservable(this, liveRealm);
    }
}

