/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.geo;

import io.realm.kotlin.internal.geo.UnmanagedGeoPolygon;
import io.realm.kotlin.types.geo.GeoPoint;
import io.realm.kotlin.types.geo.GeoPolygon;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/realm/kotlin/internal/geo/UnmanagedGeoPolygon;", "Lio/realm/kotlin/types/geo/GeoPolygon;", "outerRing", "", "Lio/realm/kotlin/types/geo/GeoPoint;", "holes", "(Ljava/util/List;Ljava/util/List;)V", "getHoles", "()Ljava/util/List;", "getOuterRing", "polygonToQueryString", "", "points", "toString", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nUnmanagedGeoPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnmanagedGeoPolygon.kt\nio/realm/kotlin/internal/geo/UnmanagedGeoPolygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1864#2,3:67\n*S KotlinDebug\n*F\n+ 1 UnmanagedGeoPolygon.kt\nio/realm/kotlin/internal/geo/UnmanagedGeoPolygon\n*L\n41#1:67,3\n*E\n"})
public final class UnmanagedGeoPolygon
implements GeoPolygon {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GeoPoint> outerRing;
    @NotNull
    private final List<List<GeoPoint>> holes;
    private static final int MIN_RING_SIZE = 3;

    /*
     * WARNING - void declaration
     */
    public UnmanagedGeoPolygon(@NotNull List<? extends GeoPoint> outerRing, @NotNull List<? extends List<? extends GeoPoint>> holes) {
        Intrinsics.checkNotNullParameter(outerRing, (String)"outerRing");
        Intrinsics.checkNotNullParameter(holes, (String)"holes");
        this.outerRing = outerRing;
        this.holes = holes;
        if (this.getOuterRing().size() < 3) {
            throw new IllegalArgumentException("The outer ring requires at least 3 points: " + this.getOuterRing().size());
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.first(this.getOuterRing()), (Object)CollectionsKt.last(this.getOuterRing()))) {
            throw new IllegalArgumentException("First and last point in the outer ring must be the same: " + CollectionsKt.first(this.getOuterRing()) + " vs. " + CollectionsKt.last(this.getOuterRing()) + ' ');
        }
        Iterable $this$forEachIndexed$iv = this.getHoles();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void ring;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int i = n;
            boolean bl = false;
            if (ring.size() < 3) {
                throw new IllegalArgumentException("The inner ring at index " + i + " requires at least 3 points: " + ring.size());
            }
            if (Intrinsics.areEqual((Object)CollectionsKt.first((List)ring), (Object)CollectionsKt.last((List)ring))) continue;
            throw new IllegalArgumentException("First and last point in the inner ring at index " + i + " must be the same: " + CollectionsKt.first(this.getOuterRing()) + " vs. " + CollectionsKt.last(this.getOuterRing()) + ' ');
        }
    }

    public /* synthetic */ UnmanagedGeoPolygon(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, list2);
    }

    @Override
    @NotNull
    public List<GeoPoint> getOuterRing() {
        return this.outerRing;
    }

    @Override
    @NotNull
    public List<List<GeoPoint>> getHoles() {
        return this.holes;
    }

    @Override
    @NotNull
    public String toString() {
        String outerRingString = this.polygonToQueryString(this.getOuterRing());
        String innerRingString2 = CollectionsKt.joinToString$default((Iterable)this.getHoles(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<List<? extends GeoPoint>, CharSequence>(this){
            final /* synthetic */ UnmanagedGeoPolygon this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull List<? extends GeoPoint> hole) {
                Intrinsics.checkNotNullParameter(hole, (String)"hole");
                return UnmanagedGeoPolygon.access$polygonToQueryString(this.this$0, hole);
            }
        }), (int)30, null);
        if (((CharSequence)innerRingString2).length() > 0) {
            return "geoPolygon(" + outerRingString + ", " + innerRingString2 + ')';
        }
        return "geoPolygon(" + outerRingString + ')';
    }

    private final String polygonToQueryString(List<? extends GeoPoint> points) {
        return CollectionsKt.joinToString$default((Iterable)points, null, (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)polygonToQueryString.1.INSTANCE, (int)25, null);
    }

    public static final /* synthetic */ String access$polygonToQueryString(UnmanagedGeoPolygon $this, List points) {
        return $this.polygonToQueryString(points);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/kotlin/internal/geo/UnmanagedGeoPolygon$Companion;", "", "()V", "MIN_RING_SIZE", "", "io.realm.kotlin.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

