/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import io.realm.kotlin.types.RealmObject;
import io.realm.kotlin.types.RealmUUID;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonObjectId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J%\u0010&\u001a\u0002H\u0001\"\b\b\u0001\u0010\u0001*\u00020'2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0014\u0010/\u001a\u0002002\n\u00101\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0013\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u00105\u001a\u00020\u001fH\u0016J\b\u00106\u001a\u00020.H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00067"}, d2={"Lio/realm/kotlin/internal/RealmAnyImpl;", "T", "", "Lio/realm/kotlin/types/RealmAny;", "type", "Lio/realm/kotlin/types/RealmAny$Type;", "clazz", "Lkotlin/reflect/KClass;", "value", "(Lio/realm/kotlin/types/RealmAny$Type;Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "getClazz$io_realm_kotlin_library", "()Lkotlin/reflect/KClass;", "internalValue", "getType", "()Lio/realm/kotlin/types/RealmAny$Type;", "asBoolean", "", "asByte", "", "asByteArray", "", "asChar", "", "asDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "Lorg/mongodb/kbson/Decimal128;", "asDouble", "", "asFloat", "", "asInt", "", "asLong", "", "asObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "asRealmInstant", "Lio/realm/kotlin/types/RealmInstant;", "asRealmObject", "Lio/realm/kotlin/types/BaseRealmObject;", "(Lkotlin/reflect/KClass;)Lio/realm/kotlin/types/BaseRealmObject;", "asRealmUUID", "Lio/realm/kotlin/types/RealmUUID;", "asShort", "", "asString", "", "checkOverFlow", "", "numeric", "equals", "other", "getValue", "hashCode", "toString", "io.realm.kotlin.library"})
public final class RealmAnyImpl<T>
implements RealmAny {
    @NotNull
    private final RealmAny.Type type;
    @NotNull
    private final KClass<T> clazz;
    @NotNull
    private final Object internalValue;

    public RealmAnyImpl(@NotNull RealmAny.Type type, @NotNull KClass<T> clazz, @NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.type = type;
        this.clazz = clazz;
        if (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()] == 1) {
            long l;
            Object object2 = value;
            if (object2 instanceof Number) {
                l = ((Number)value).longValue();
            } else if (object2 instanceof Character) {
                l = ((Character)value).charValue();
            } else {
                throw new IllegalArgumentException("Unsupported numeric type. Only Long, Short, Int, Byte and Char are valid numeric types.");
            }
            object = l;
        } else {
            object = value;
        }
        this.internalValue = object;
    }

    @Override
    @NotNull
    public RealmAny.Type getType() {
        return this.type;
    }

    @NotNull
    public final KClass<T> getClazz$io_realm_kotlin_library() {
        return this.clazz;
    }

    @Override
    public short asShort() {
        this.checkOverFlow(Reflection.getOrCreateKotlinClass(Short.TYPE));
        Object object = this.getValue(RealmAny.Type.INT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (short)((Long)object).longValue();
    }

    @Override
    public int asInt() {
        this.checkOverFlow(Reflection.getOrCreateKotlinClass(Integer.TYPE));
        Object object = this.getValue(RealmAny.Type.INT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (int)((Long)object).longValue();
    }

    @Override
    public byte asByte() {
        this.checkOverFlow(Reflection.getOrCreateKotlinClass(Byte.TYPE));
        Object object = this.getValue(RealmAny.Type.INT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (byte)((Long)object).longValue();
    }

    @Override
    public char asChar() {
        this.checkOverFlow(Reflection.getOrCreateKotlinClass(Character.TYPE));
        Object object = this.getValue(RealmAny.Type.INT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (char)((Long)object).longValue();
    }

    @Override
    public long asLong() {
        Object object = this.getValue(RealmAny.Type.INT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    @Override
    public boolean asBoolean() {
        Object object = this.getValue(RealmAny.Type.BOOL);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Override
    @NotNull
    public String asString() {
        Object object = this.getValue(RealmAny.Type.STRING);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @Override
    public float asFloat() {
        Object object = this.getValue(RealmAny.Type.FLOAT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue();
    }

    @Override
    public double asDouble() {
        Object object = this.getValue(RealmAny.Type.DOUBLE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        return (Double)object;
    }

    @Override
    @NotNull
    public BsonDecimal128 asDecimal128() {
        Object object = this.getValue(RealmAny.Type.DECIMAL128);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.mongodb.kbson.BsonDecimal128{ org.mongodb.kbson.Decimal128Kt.Decimal128 }");
        return (BsonDecimal128)object;
    }

    @Override
    @NotNull
    public BsonObjectId asObjectId() {
        Object object = this.getValue(RealmAny.Type.OBJECT_ID);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.mongodb.kbson.BsonObjectId");
        return (BsonObjectId)object;
    }

    @Override
    @NotNull
    public byte[] asByteArray() {
        Object object = this.getValue(RealmAny.Type.BINARY);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        return (byte[])object;
    }

    @Override
    @NotNull
    public RealmInstant asRealmInstant() {
        Object object = this.getValue(RealmAny.Type.TIMESTAMP);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.realm.kotlin.types.RealmInstant");
        return (RealmInstant)object;
    }

    @Override
    @NotNull
    public RealmUUID asRealmUUID() {
        Object object = this.getValue(RealmAny.Type.UUID);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.realm.kotlin.types.RealmUUID");
        return (RealmUUID)object;
    }

    @Override
    @NotNull
    public <T extends BaseRealmObject> T asRealmObject(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object getValue = this.getValue(RealmAny.Type.OBJECT);
        return (T)((BaseRealmObject)KClasses.cast(clazz, (Object)getValue));
    }

    private final Object getValue(RealmAny.Type type) {
        if (this.getType() != type) {
            throw new IllegalStateException("RealmAny type mismatch, wanted a '" + type.name() + "' but the instance is a '" + this.getType().name() + "'.");
        }
        return this.internalValue;
    }

    private final void checkOverFlow(KClass<?> numeric) {
        long l;
        Object internalValue = this.getValue(RealmAny.Type.INT);
        if (internalValue instanceof Number) {
            l = ((Number)internalValue).longValue();
        } else {
            Intrinsics.checkNotNull((Object)internalValue, (String)"null cannot be cast to non-null type kotlin.Char");
            l = ((Character)internalValue).charValue();
        }
        long storageTypeValue = l;
        KClass<?> kClass = numeric;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (storageTypeValue > 32767L) {
                throw new ArithmeticException("Cannot convert value with 'asShort' due to overflow for value " + storageTypeValue);
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (storageTypeValue > Integer.MAX_VALUE) {
                throw new ArithmeticException("Cannot convert value with 'asInt' due to overflow for value " + storageTypeValue);
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (storageTypeValue > 127L) {
                throw new ArithmeticException("Cannot convert value with 'asByte' due to overflow for value " + storageTypeValue);
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) && storageTypeValue > 65535L) {
            throw new ArithmeticException("Cannot convert value with 'asChar' due to overflow for value " + storageTypeValue);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof RealmAnyImpl)) {
            return false;
        }
        if (((RealmAnyImpl)other).getType() != this.getType()) {
            return false;
        }
        if (Intrinsics.areEqual(this.clazz, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            if (!(((RealmAnyImpl)other).internalValue instanceof byte[])) {
                return false;
            }
            byte[] byArray = (byte[])((RealmAnyImpl)other).internalValue;
            Object object = this.internalValue;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            return Arrays.equals(byArray, (byte[])object);
        }
        if (this.internalValue instanceof RealmObject) {
            if (!Intrinsics.areEqual(((RealmAnyImpl)other).clazz, this.clazz)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((RealmAnyImpl)other).internalValue, (Object)this.internalValue);
        }
        return Intrinsics.areEqual((Object)this.internalValue, (Object)((RealmAnyImpl)other).internalValue);
    }

    @Override
    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + this.internalValue.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "RealmAny{type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue(this.getType()) + '}';
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RealmAny.Type.values().length];
            try {
                nArray[RealmAny.Type.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

