/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.geo;

import io.realm.kotlin.types.geo.Distance;
import io.realm.kotlin.types.geo.GeoCircle;
import io.realm.kotlin.types.geo.GeoPoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/realm/kotlin/internal/geo/UnmanagedGeoCircle;", "Lio/realm/kotlin/types/geo/GeoCircle;", "center", "Lio/realm/kotlin/types/geo/GeoPoint;", "radius", "Lio/realm/kotlin/types/geo/Distance;", "(Lio/realm/kotlin/types/geo/GeoPoint;Lio/realm/kotlin/types/geo/Distance;)V", "getCenter", "()Lio/realm/kotlin/types/geo/GeoPoint;", "getRadius", "()Lio/realm/kotlin/types/geo/Distance;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "io.realm.kotlin.library"})
public final class UnmanagedGeoCircle
implements GeoCircle {
    @NotNull
    private final GeoPoint center;
    @NotNull
    private final Distance radius;

    public UnmanagedGeoCircle(@NotNull GeoPoint center, @NotNull Distance radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
        this.center = center;
        this.radius = radius;
        if (this.getRadius().getInRadians() < 0.0) {
            throw new IllegalArgumentException("A negative radius is not allowed: " + this.getRadius());
        }
    }

    @Override
    @NotNull
    public GeoPoint getCenter() {
        return this.center;
    }

    @Override
    @NotNull
    public Distance getRadius() {
        return this.radius;
    }

    @Override
    @NotNull
    public String toString() {
        return "geoCircle([" + this.getCenter().getLongitude() + ", " + this.getCenter().getLatitude() + "], " + this.getRadius().getInRadians() + ')';
    }

    @NotNull
    public final GeoPoint component1() {
        return this.center;
    }

    @NotNull
    public final Distance component2() {
        return this.radius;
    }

    @NotNull
    public final UnmanagedGeoCircle copy(@NotNull GeoPoint center, @NotNull Distance radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
        return new UnmanagedGeoCircle(center, radius);
    }

    public static /* synthetic */ UnmanagedGeoCircle copy$default(UnmanagedGeoCircle unmanagedGeoCircle, GeoPoint geoPoint, Distance distance, int n, Object object) {
        if ((n & 1) != 0) {
            geoPoint = unmanagedGeoCircle.center;
        }
        if ((n & 2) != 0) {
            distance = unmanagedGeoCircle.radius;
        }
        return unmanagedGeoCircle.copy(geoPoint, distance);
    }

    public int hashCode() {
        int result = this.center.hashCode();
        result = result * 31 + this.radius.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnmanagedGeoCircle)) {
            return false;
        }
        UnmanagedGeoCircle unmanagedGeoCircle = (UnmanagedGeoCircle)other;
        if (!Intrinsics.areEqual((Object)this.center, (Object)unmanagedGeoCircle.center)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.radius, (Object)unmanagedGeoCircle.radius);
    }
}

