/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.Flowable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.Mediator;
import io.realm.kotlin.internal.Observable;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmState;
import io.realm.kotlin.internal.RealmStateHolder;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.PropertyKey;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.interop.RealmObjectInterop;
import io.realm.kotlin.internal.interop.RealmObjectT;
import io.realm.kotlin.internal.interop.RealmT;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.notifications.ObjectChange;
import io.realm.kotlin.notifications.internal.DeletedObjectImpl;
import io.realm.kotlin.notifications.internal.InitialObjectImpl;
import io.realm.kotlin.notifications.internal.UpdatedObjectImpl;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 I*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0000\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00070\u00062\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00070\b:\u0001IB=\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00070%H\u0016J\r\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020'H\u0016JN\u0010*\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010+2\u0006\u0010,\u001a\u00020\u000e2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020.0\u0012j\u0002`/2\u0014\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000701H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b2J\u001a\u00103\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00002\u0006\u0010,\u001a\u00020\u000eH\u0016J%\u00104\u001a\b\u0012\u0004\u0012\u00020\n052\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020.0\u0012j\u0002`/H\u0002\u00a2\u0006\u0002\u00106J\r\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\b9J<\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010;\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00142\u0010\b\u0002\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\fH\u0002J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\nJ\b\u0010@\u001a\u00020AH\u0016J*\u0010B\u001a\f\u0012\u0004\u0012\u00020C0\u0012j\u0002`D2\u0016\u0010E\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020.0\u0012j\u0002`/0FH\u0016J\u001a\u0010G\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00002\u0006\u0010H\u001a\u00020\u000eH\u0016J(\u0010G\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00002\u0006\u0010H\u001a\u00020\u000e2\u000e\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006J"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference;", "T", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/internal/RealmStateHolder;", "Lio/realm/kotlin/internal/interop/RealmObjectInterop;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/Observable;", "Lio/realm/kotlin/notifications/ObjectChange;", "Lio/realm/kotlin/internal/Flowable;", "className", "", "type", "Lkotlin/reflect/KClass;", "owner", "Lio/realm/kotlin/internal/RealmReference;", "mediator", "Lio/realm/kotlin/internal/Mediator;", "objectPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmObjectT;", "Lio/realm/kotlin/internal/interop/RealmObjectPointer;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Lio/realm/kotlin/internal/RealmReference;Lio/realm/kotlin/internal/Mediator;Lio/realm/kotlin/internal/interop/NativePointer;)V", "getClassName", "()Ljava/lang/String;", "getMediator", "()Lio/realm/kotlin/internal/Mediator;", "metadata", "Lio/realm/kotlin/internal/schema/ClassMetadata;", "getMetadata", "()Lio/realm/kotlin/internal/schema/ClassMetadata;", "getObjectPointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOwner", "()Lio/realm/kotlin/internal/RealmReference;", "getType$io_realm_kotlin_library", "()Lkotlin/reflect/KClass;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "checkValid", "", "checkValid$io_realm_kotlin_library", "delete", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "change", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "getChangedFieldNames", "", "(Lio/realm/kotlin/internal/interop/NativePointer;)[Ljava/lang/String;", "isValid", "", "isValid$io_realm_kotlin_library", "newObjectReference", "pointer", "clazz", "propertyInfoOrThrow", "Lio/realm/kotlin/internal/schema/PropertyMetadata;", "propertyName", "realmState", "Lio/realm/kotlin/internal/RealmState;", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "thaw", "liveRealm", "Companion", "io.realm.kotlin.library"})
public final class RealmObjectReference<T extends BaseRealmObject>
implements RealmStateHolder,
RealmObjectInterop,
InternalDeleteable,
Observable<RealmObjectReference<? extends BaseRealmObject>, ObjectChange<? extends BaseRealmObject>>,
Flowable<ObjectChange<? extends BaseRealmObject>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String className;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final RealmReference owner;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final NativePointer<RealmObjectT> objectPointer;
    @NotNull
    private final ClassMetadata metadata;
    @NotNull
    public static final String INVALID_OBJECT_MSG = "Cannot perform this operation on an invalid/deleted object";

    public RealmObjectReference(@NotNull String className, @NotNull KClass<T> type, @NotNull RealmReference owner, @NotNull Mediator mediator, @NotNull NativePointer<RealmObjectT> objectPointer) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(objectPointer, (String)"objectPointer");
        this.className = className;
        this.type = type;
        this.owner = owner;
        this.mediator = mediator;
        this.objectPointer = objectPointer;
        ClassMetadata classMetadata = this.owner.getSchemaMetadata().get(this.className);
        Intrinsics.checkNotNull((Object)classMetadata);
        this.metadata = classMetadata;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final KClass<T> getType$io_realm_kotlin_library() {
        return this.type;
    }

    @NotNull
    public final RealmReference getOwner() {
        return this.owner;
    }

    @NotNull
    public final Mediator getMediator() {
        return this.mediator;
    }

    @NotNull
    public NativePointer<RealmObjectT> getObjectPointer() {
        return this.objectPointer;
    }

    @NotNull
    public final ClassMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final PropertyMetadata propertyInfoOrThrow(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.metadata.getOrThrow(propertyName);
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.owner;
    }

    private final RealmObjectReference<? extends BaseRealmObject> newObjectReference(RealmReference owner, NativePointer<RealmObjectT> pointer, KClass<? extends BaseRealmObject> clazz) {
        Mediator mediator = this.mediator;
        String string = this.className;
        return new RealmObjectReference<BaseRealmObject>(string, clazz, owner, mediator, pointer);
    }

    static /* synthetic */ RealmObjectReference newObjectReference$default(RealmObjectReference realmObjectReference, RealmReference realmReference2, NativePointer nativePointer, KClass kClass, int n, Object object) {
        if ((n & 4) != 0) {
            kClass = realmObjectReference.type;
        }
        return realmObjectReference.newObjectReference(realmReference2, (NativePointer<RealmObjectT>)nativePointer, kClass);
    }

    @Override
    @Nullable
    public RealmObjectReference<? extends BaseRealmObject> freeze(@NotNull RealmReference frozenRealm) {
        RealmObjectReference realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = RealmObjectReference.newObjectReference$default(this, frozenRealm, pointer, null, 4, null);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @Nullable
    public RealmObjectReference<? extends BaseRealmObject> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return this.thaw(liveRealm, this.type);
    }

    @Nullable
    public final RealmObjectReference<? extends BaseRealmObject> thaw(@NotNull RealmReference liveRealm, @NotNull KClass<? extends BaseRealmObject> clazz) {
        RealmObjectReference<BaseRealmObject> realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        NativePointer<? extends RealmT> dbPointer = liveRealm.getDbPointer();
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), dbPointer);
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = this.newObjectReference(liveRealm, (NativePointer<RealmObjectT>)pointer, clazz);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_object_add_notification_callback(this.getObjectPointer(), callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer<RealmChangesT> change, @NotNull SendChannel<? super ObjectChange<? extends BaseRealmObject>> channel) {
        ChannelResult channelResult;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Object frozenObject = this.freeze(frozenRealm);
        if (frozenObject == null) {
            ChannelResult channelResult2 = ChannelResult.box-impl((Object)channel.trySend-JP2dKIU(new DeletedObjectImpl()));
            Object it = channelResult2.unbox-impl();
            boolean bl = false;
            SendChannel.DefaultImpls.close$default(channel, null, (int)1, null);
            channelResult = channelResult2;
        } else {
            String[] changedFieldNames = super.getChangedFieldNames(change);
            Object obj = RealmObjectUtilKt.toRealmObject(frozenObject);
            channelResult = ChannelResult.box-impl((Object)(changedFieldNames.length == 0 ? channel.trySend-JP2dKIU(new InitialObjectImpl(obj)) : channel.trySend-JP2dKIU(new UpdatedObjectImpl(obj, changedFieldNames))));
        }
        return channelResult;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getChangedFieldNames(NativePointer<RealmChangesT> change) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RealmInterop.INSTANCE.realm_object_changes_get_modified_properties(change);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void propertyKey;
            long l = ((PropertyKey)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.metadata.get-XxIY2SY((long)propertyKey);
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    @Override
    @NotNull
    public Flow<ObjectChange<? extends BaseRealmObject>> asFlow() {
        return this.owner.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    public void delete() {
        if (this.isFrozen()) {
            throw new IllegalArgumentException("Frozen objects cannot be deleted. They must be converted to live objects first by using `MutableRealm/DynamicMutableRealm.findLatest(frozenObject)`.");
        }
        if (!this.isValid$io_realm_kotlin_library()) {
            throw new IllegalArgumentException(INVALID_OBJECT_MSG);
        }
        NativePointer<RealmObjectT> it = this.getObjectPointer();
        boolean bl = false;
        RealmInterop.INSTANCE.realm_object_delete(it);
    }

    public final boolean isValid$io_realm_kotlin_library() {
        NativePointer<RealmObjectT> ptr = this.getObjectPointer();
        return ptr != null ? RealmInterop.INSTANCE.realm_object_is_valid(ptr) : false;
    }

    public final void checkValid$io_realm_kotlin_library() {
        if (!this.isValid$io_realm_kotlin_library()) {
            throw new IllegalStateException(INVALID_OBJECT_MSG);
        }
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference$Companion;", "", "()V", "INVALID_OBJECT_MSG", "", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

