/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.RealmState;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmT;
import io.realm.kotlin.internal.schema.SchemaMetadata;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001e\u0010\u0002\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/realm/kotlin/internal/RealmReference;", "Lio/realm/kotlin/internal/RealmState;", "dbPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmT;", "Lio/realm/kotlin/internal/interop/RealmPointer;", "getDbPointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "owner", "Lio/realm/kotlin/internal/BaseRealmImpl;", "getOwner", "()Lio/realm/kotlin/internal/BaseRealmImpl;", "schemaMetadata", "Lio/realm/kotlin/internal/schema/SchemaMetadata;", "getSchemaMetadata", "()Lio/realm/kotlin/internal/schema/SchemaMetadata;", "asValidLiveRealmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "checkClosed", "", "close", "isClosed", "", "isFrozen", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
public interface RealmReference
extends RealmState {
    @NotNull
    public BaseRealmImpl getOwner();

    @NotNull
    public SchemaMetadata getSchemaMetadata();

    @NotNull
    public NativePointer<? extends RealmT> getDbPointer();

    @Override
    @NotNull
    public VersionId version();

    @Override
    public boolean isFrozen();

    @Override
    public boolean isClosed();

    public void close();

    @NotNull
    public LiveRealmReference asValidLiveRealmReference();

    public void checkClosed();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static VersionId version(@NotNull RealmReference $this) {
            $this.checkClosed();
            return new VersionId(RealmInterop.INSTANCE.realm_get_version_id($this.getDbPointer()));
        }

        public static boolean isFrozen(@NotNull RealmReference $this) {
            $this.checkClosed();
            return RealmInterop.INSTANCE.realm_is_frozen($this.getDbPointer());
        }

        public static boolean isClosed(@NotNull RealmReference $this) {
            return RealmInterop.INSTANCE.realm_is_closed($this.getDbPointer());
        }

        public static void close(@NotNull RealmReference $this) {
            $this.checkClosed();
            RealmInterop.INSTANCE.realm_close($this.getDbPointer());
        }

        @NotNull
        public static LiveRealmReference asValidLiveRealmReference(@NotNull RealmReference $this) {
            if (!($this instanceof LiveRealmReference)) {
                throw new IllegalStateException("Cannot modify managed objects outside of a write transaction");
            }
            $this.checkClosed();
            return (LiveRealmReference)$this;
        }

        public static void checkClosed(@NotNull RealmReference $this) {
            if ($this.isClosed()) {
                throw new IllegalStateException("Realm has been closed and is no longer accessible: " + $this.getOwner().getConfiguration().getPath());
            }
        }
    }
}

