/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.dynamic;

import io.realm.kotlin.Deleteable;
import io.realm.kotlin.UpdatePolicy;
import io.realm.kotlin.dynamic.DynamicMutableRealm;
import io.realm.kotlin.dynamic.DynamicMutableRealmObject;
import io.realm.kotlin.dynamic.DynamicRealm;
import io.realm.kotlin.dynamic.DynamicRealmObject;
import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.InternalDeleteableKt;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmUtilsKt;
import io.realm.kotlin.internal.WriteTransactionManager;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.query.ObjectQuery;
import io.realm.kotlin.internal.schema.RealmSchemaImpl;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.schema.RealmClass;
import io.realm.kotlin.schema.RealmSchema;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J;\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0016\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010&0%\"\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lio/realm/kotlin/internal/dynamic/DynamicMutableRealmImpl;", "Lio/realm/kotlin/internal/BaseRealmImpl;", "Lio/realm/kotlin/dynamic/DynamicMutableRealm;", "Lio/realm/kotlin/internal/WriteTransactionManager;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "realm", "Lkotlin/Pair;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/LiveRealmT;", "Lio/realm/kotlin/internal/interop/LiveRealmPointer;", "", "(Lio/realm/kotlin/internal/InternalConfiguration;Lkotlin/Pair;)V", "dbPointer", "(Lio/realm/kotlin/internal/InternalConfiguration;Lio/realm/kotlin/internal/interop/NativePointer;)V", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "close", "", "copyToRealm", "Lio/realm/kotlin/dynamic/DynamicMutableRealmObject;", "obj", "Lio/realm/kotlin/dynamic/DynamicRealmObject;", "updatePolicy", "Lio/realm/kotlin/UpdatePolicy;", "delete", "deleteable", "Lio/realm/kotlin/Deleteable;", "className", "", "deleteAll", "findLatest", "query", "Lio/realm/kotlin/query/RealmQuery;", "args", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "schema", "Lio/realm/kotlin/schema/RealmSchema;", "io.realm.kotlin.library"})
public class DynamicMutableRealmImpl
extends BaseRealmImpl
implements DynamicMutableRealm,
WriteTransactionManager {
    @NotNull
    private final LiveRealmReference realmReference;

    public DynamicMutableRealmImpl(@NotNull InternalConfiguration configuration, @NotNull NativePointer<LiveRealmT> dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(dbPointer, (String)"dbPointer");
        super(configuration);
        this.realmReference = new LiveRealmReference(this, dbPointer);
    }

    public DynamicMutableRealmImpl(@NotNull InternalConfiguration configuration, @NotNull Pair<? extends NativePointer<LiveRealmT>, Boolean> realm) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        this(configuration, (NativePointer<LiveRealmT>)((NativePointer)realm.getFirst()));
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference() {
        return this.realmReference;
    }

    @Override
    @NotNull
    public RealmQuery<DynamicMutableRealmObject> query(@NotNull String className, @NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectQuery(this.getRealmReference(), this.getRealmReference().getSchemaMetadata().getOrThrow(className).getClassKey-QNRHIEo(), Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class), this.getConfiguration().getMediator(), query2, args, null);
    }

    @Override
    @NotNull
    public DynamicMutableRealmObject copyToRealm(@NotNull DynamicRealmObject obj, @NotNull UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        BaseRealmObject baseRealmObject = RealmUtilsKt.copyToRealm(this.getConfiguration().getMediator(), this.getRealmReference(), (BaseRealmObject)obj, updatePolicy, new LinkedHashMap());
        Intrinsics.checkNotNull((Object)baseRealmObject, (String)"null cannot be cast to non-null type io.realm.kotlin.dynamic.DynamicMutableRealmObject");
        return (DynamicMutableRealmObject)baseRealmObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public DynamicMutableRealmObject findLatest(@NotNull DynamicRealmObject obj) {
        DynamicMutableRealmObject dynamicMutableRealmObject;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!BaseRealmObjectExtKt.isValid(obj)) {
            dynamicMutableRealmObject = null;
            return dynamicMutableRealmObject;
        } else {
            DynamicMutableRealmObject dynamicMutableRealmObject2;
            BaseRealmObject $this$runIfManaged$iv = obj;
            boolean $i$f$runIfManaged = false;
            RealmObjectReference<? extends BaseRealmObject> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference($this$runIfManaged$iv);
            if (realmObjectReference != null) {
                RealmObjectReference<? extends BaseRealmObject> $this$findLatest_u24lambda_u240 = realmObjectReference;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$this$findLatest_u24lambda_u240.getOwner(), (Object)this.getRealmReference())) RealmObjectReference<BaseRealmObject> realmObjectReference2;
                return (DynamicMutableRealmObject)((realmObjectReference2 = $this$findLatest_u24lambda_u240.thaw(this.getRealmReference(), (KClass<BaseRealmObject>)Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class))) != null ? RealmObjectUtilKt.toRealmObject(realmObjectReference2) : null);
                dynamicMutableRealmObject2 = (DynamicMutableRealmObject)obj;
            } else {
                dynamicMutableRealmObject2 = dynamicMutableRealmObject = null;
            }
            if (dynamicMutableRealmObject2 != null) return dynamicMutableRealmObject;
            throw new IllegalArgumentException("Cannot lookup unmanaged object");
        }
    }

    @Override
    public void delete(@NotNull Deleteable deleteable) {
        Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
        InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
    }

    @Override
    public void delete(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.delete(DynamicRealm.DefaultImpls.query$default(this, className, null, new Object[0], 2, null).find());
    }

    @Override
    public void deleteAll() {
        for (RealmClass schemaClass : this.schema().getClasses()) {
            this.delete(schemaClass.getName());
        }
    }

    @Override
    @NotNull
    public RealmSchema schema() {
        return RealmSchemaImpl.Companion.fromDynamicRealm(this.getRealmReference().getDbPointer());
    }

    public void close() {
        super.close$io_realm_kotlin_library();
    }

    @Override
    public void beginTransaction() {
        WriteTransactionManager.DefaultImpls.beginTransaction(this);
    }

    @Override
    public boolean isInTransaction() {
        return WriteTransactionManager.DefaultImpls.isInTransaction(this);
    }

    @Override
    public void commitTransaction() {
        WriteTransactionManager.DefaultImpls.commitTransaction(this);
    }

    @Override
    public void cancelWrite() {
        WriteTransactionManager.DefaultImpls.cancelWrite(this);
    }
}

