/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import android.os.Build;
import io.realm.kotlin.internal.RealmInitializer;
import io.realm.kotlin.internal.interop.SyncConnectionParams;
import io.realm.kotlin.internal.platform.LogCatLogger;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0017\u0010\f\u001a\u00020\r\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0011\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0003\u00a8\u0006\u001a"}, d2={"CPU_ARCH", "", "getCPU_ARCH", "()Ljava/lang/String;", "DEVICE_MANUFACTURER", "getDEVICE_MANUFACTURER", "DEVICE_MODEL", "getDEVICE_MODEL", "OS_NAME", "getOS_NAME", "OS_VERSION", "getOS_VERSION", "RUNTIME", "Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "getRUNTIME$annotations", "()V", "getRUNTIME", "()Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "RUNTIME_VERSION", "getRUNTIME_VERSION", "appFilesDirectory", "createDefaultSystemLogger", "Lio/realm/kotlin/log/RealmLogger;", "tag", "logLevel", "Lio/realm/kotlin/log/LogLevel;", "io.realm.kotlin.library"})
public final class SystemUtilsAndroidKt {
    @NotNull
    private static final SyncConnectionParams.Runtime RUNTIME;
    @NotNull
    private static final String RUNTIME_VERSION;
    @NotNull
    private static final String CPU_ARCH;
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String DEVICE_MANUFACTURER;
    @NotNull
    private static final String DEVICE_MODEL;

    @NotNull
    public static final SyncConnectionParams.Runtime getRUNTIME() {
        return RUNTIME;
    }

    public static /* synthetic */ void getRUNTIME$annotations() {
    }

    @NotNull
    public static final String getRUNTIME_VERSION() {
        return RUNTIME_VERSION;
    }

    @NotNull
    public static final String getCPU_ARCH() {
        return CPU_ARCH;
    }

    @NotNull
    public static final String getOS_NAME() {
        return OS_NAME;
    }

    @NotNull
    public static final String getOS_VERSION() {
        return OS_VERSION;
    }

    @NotNull
    public static final String getDEVICE_MANUFACTURER() {
        return DEVICE_MANUFACTURER;
    }

    @NotNull
    public static final String getDEVICE_MODEL() {
        return DEVICE_MODEL;
    }

    @NotNull
    public static final String appFilesDirectory() {
        String string = RealmInitializer.Companion.getFilesDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RealmInitializer.filesDir.absolutePath");
        return string;
    }

    @NotNull
    public static final RealmLogger createDefaultSystemLogger(@NotNull String tag, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        return new LogCatLogger(tag, logLevel);
    }

    public static /* synthetic */ RealmLogger createDefaultSystemLogger$default(String string, LogLevel logLevel, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.NONE;
        }
        return SystemUtilsAndroidKt.createDefaultSystemLogger(string, logLevel);
    }

    static {
        String string;
        RUNTIME = SyncConnectionParams.Runtime.ANDROID;
        RUNTIME_VERSION = String.valueOf(Build.VERSION.SDK_INT);
        if (Build.VERSION.SDK_INT < 21) {
            String string2 = Build.CPU_ABI;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        @Suppress(\"DEP\u2026id.os.Build.CPU_ABI\n    }");
        } else {
            String string3 = Build.SUPPORTED_ABIS[0];
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        android.os.Build.SUPPORTED_ABIS[0]\n    }");
            string = string3;
        }
        CPU_ARCH = string;
        OS_NAME = "Android";
        String string4 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"RELEASE");
        OS_VERSION = string4;
        String string5 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MANUFACTURER");
        DEVICE_MANUFACTURER = string5;
        String string6 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MODEL");
        DEVICE_MODEL = string6;
    }
}

