/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.ChangeFlow;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.LiveRealm;
import io.realm.kotlin.internal.Mediator;
import io.realm.kotlin.internal.Notifiable;
import io.realm.kotlin.internal.ObjectChangeFlow;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmState;
import io.realm.kotlin.internal.RealmStateHolder;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.ClassKey;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.PropertyKey;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmKeyPathArrayT;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.interop.RealmObjectInterop;
import io.realm.kotlin.internal.interop.RealmObjectT;
import io.realm.kotlin.internal.interop.RealmT;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.notifications.ObjectChange;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 O*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u0006:\u0001OB?\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\tJ\b\u0010(\u001a\u00020)H\u0016JA\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0010\u0010+\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00112\u0010\b\u0002\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010/\u001a\u00020\rH\u0016J\u0018\u00100\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00101\u001a\u00020\rH\u0016J&\u00100\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00101\u001a\u00020\r2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bJE\u00102\u001a\f\u0012\u0004\u0012\u0002040\u0012j\u0002`32\u0014\u00105\u001a\u0010\u0012\u0004\u0012\u000207\u0018\u00010\u0012j\u0004\u0018\u0001`62\u0016\u00108\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020;0\u0012j\u0002`:09H\u0016\u00a2\u0006\u0002\u0010<J4\u0010=\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070>2\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070@H\u0016J'\u0010A\u001a\b\u0012\u0004\u0012\u00020\t0B2\u0010\u0010C\u001a\f\u0012\u0004\u0012\u00020;0\u0012j\u0002`:H\u0000\u00a2\u0006\u0004\bD\u0010EJ$\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070G2\u000e\u00105\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010HH\u0016J\b\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020LH\u0016J\r\u0010M\u001a\u00020JH\u0000\u00a2\u0006\u0002\bNR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006P"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference;", "T", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/internal/RealmStateHolder;", "Lio/realm/kotlin/internal/interop/RealmObjectInterop;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/CoreNotifiable;", "Lio/realm/kotlin/notifications/ObjectChange;", "className", "", "type", "Lkotlin/reflect/KClass;", "owner", "Lio/realm/kotlin/internal/RealmReference;", "mediator", "Lio/realm/kotlin/internal/Mediator;", "objectPointer", "Lio/realm/kotlin/internal/interop/RealmObjectPointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmObjectT;", "<init>", "(Ljava/lang/String;Lkotlin/reflect/KClass;Lio/realm/kotlin/internal/RealmReference;Lio/realm/kotlin/internal/Mediator;Lio/realm/kotlin/internal/interop/NativePointer;)V", "getClassName", "()Ljava/lang/String;", "getType", "()Lkotlin/reflect/KClass;", "getOwner", "()Lio/realm/kotlin/internal/RealmReference;", "getMediator", "()Lio/realm/kotlin/internal/Mediator;", "getObjectPointer", "()Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "metadata", "Lio/realm/kotlin/internal/schema/ClassMetadata;", "getMetadata", "()Lio/realm/kotlin/internal/schema/ClassMetadata;", "propertyInfoOrThrow", "Lio/realm/kotlin/internal/schema/PropertyMetadata;", "propertyName", "realmState", "Lio/realm/kotlin/internal/RealmState;", "newObjectReference", "pointer", "clazz", "(Lio/realm/kotlin/internal/RealmReference;Lio/realm/kotlin/internal/interop/NativePointer;Lkotlin/reflect/KClass;)Lio/realm/kotlin/internal/RealmObjectReference;", "freeze", "frozenRealm", "thaw", "liveRealm", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "keyPaths", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayPointer;", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayT;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/interop/Callback;)Lio/realm/kotlin/internal/interop/NativePointer;", "changeFlow", "Lio/realm/kotlin/internal/ChangeFlow;", "scope", "Lkotlinx/coroutines/channels/ProducerScope;", "getChangedFieldNames", "", "change", "getChangedFieldNames$io_realm_kotlin_library", "(Lio/realm/kotlin/internal/interop/NativePointer;)[Ljava/lang/String;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "", "delete", "", "isValid", "", "checkValid", "checkValid$io_realm_kotlin_library", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmObjectReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmObjectReference.kt\nio/realm/kotlin/internal/RealmObjectReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1557#2:199\n1628#2,3:200\n37#3,2:203\n1#4:205\n*S KotlinDebug\n*F\n+ 1 RealmObjectReference.kt\nio/realm/kotlin/internal/RealmObjectReference\n*L\n129#1:199\n129#1:200,3\n131#1:203,2\n*E\n"})
public final class RealmObjectReference<T extends BaseRealmObject>
implements RealmStateHolder,
RealmObjectInterop,
InternalDeleteable,
CoreNotifiable<RealmObjectReference<T>, ObjectChange<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String className;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final RealmReference owner;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final NativePointer<RealmObjectT> objectPointer;
    @NotNull
    private final ClassMetadata metadata;
    @NotNull
    public static final String INVALID_OBJECT_MSG = "Cannot perform this operation on an invalid/deleted object";

    public RealmObjectReference(@NotNull String className, @NotNull KClass<T> type, @NotNull RealmReference owner, @NotNull Mediator mediator, @NotNull NativePointer<RealmObjectT> objectPointer) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(objectPointer, (String)"objectPointer");
        this.className = className;
        this.type = type;
        this.owner = owner;
        this.mediator = mediator;
        this.objectPointer = objectPointer;
        ClassMetadata classMetadata = this.owner.getSchemaMetadata().get(this.className);
        Intrinsics.checkNotNull((Object)classMetadata);
        this.metadata = classMetadata;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    @NotNull
    public final RealmReference getOwner() {
        return this.owner;
    }

    @NotNull
    public final Mediator getMediator() {
        return this.mediator;
    }

    @NotNull
    public NativePointer<RealmObjectT> getObjectPointer() {
        return this.objectPointer;
    }

    @NotNull
    public final ClassMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final PropertyMetadata propertyInfoOrThrow(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.metadata.getOrThrow(propertyName);
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.owner;
    }

    private final RealmObjectReference<? extends BaseRealmObject> newObjectReference(RealmReference owner, NativePointer<RealmObjectT> pointer, KClass<? extends BaseRealmObject> clazz) {
        Mediator mediator = this.mediator;
        String string = this.className;
        return new RealmObjectReference<BaseRealmObject>(string, clazz, owner, mediator, pointer);
    }

    static /* synthetic */ RealmObjectReference newObjectReference$default(RealmObjectReference realmObjectReference, RealmReference realmReference, NativePointer nativePointer, KClass kClass, int n, Object object) {
        if ((n & 4) != 0) {
            kClass = realmObjectReference.type;
        }
        return realmObjectReference.newObjectReference(realmReference, (NativePointer<RealmObjectT>)nativePointer, kClass);
    }

    @Override
    @Nullable
    public RealmObjectReference<T> freeze(@NotNull RealmReference frozenRealm) {
        RealmObjectReference realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = RealmObjectReference.newObjectReference$default(this, frozenRealm, pointer, null, 4, null);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @Nullable
    public RealmObjectReference<T> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return this.thaw(liveRealm, this.type);
    }

    @Nullable
    public final RealmObjectReference<T> thaw(@NotNull RealmReference liveRealm, @NotNull KClass<? extends BaseRealmObject> clazz) {
        RealmObjectReference<BaseRealmObject> realmObjectReference;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        NativePointer<? extends RealmT> dbPointer = liveRealm.getDbPointer();
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_object_resolve_in(this.getObjectPointer(), dbPointer);
        if (nativePointer != null) {
            NativePointer pointer = nativePointer;
            boolean bl = false;
            realmObjectReference = this.newObjectReference(liveRealm, (NativePointer<RealmObjectT>)pointer, clazz);
        } else {
            realmObjectReference = null;
        }
        return realmObjectReference;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@Nullable NativePointer<RealmKeyPathArrayT> keyPaths, @NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_object_add_notification_callback(this.getObjectPointer(), keyPaths, callback);
    }

    @Override
    @NotNull
    public ChangeFlow<RealmObjectReference<T>, ObjectChange<T>> changeFlow(@NotNull ProducerScope<? super ObjectChange<T>> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        return new ObjectChangeFlow(scope);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getChangedFieldNames$io_realm_kotlin_library(@NotNull NativePointer<RealmChangesT> change) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(change, (String)"change");
        Iterable $this$map$iv = RealmInterop.INSTANCE.realm_object_changes_get_modified_properties(change);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void propertyKey;
            long l = ((PropertyKey)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.metadata.get-XxIY2SY((long)propertyKey);
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public Flow<ObjectChange<T>> asFlow(@Nullable List<String> keyPaths) {
        Pair pair;
        List<String> list = keyPaths;
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            pair = new Pair((Object)ClassKey.box-impl((long)this.metadata.getClassKey-QNRHIEo()), it);
        } else {
            pair = null;
        }
        Pair keyPathInfo = pair;
        return this.owner.getOwner().registerObserver$io_realm_kotlin_library(this, (Pair<ClassKey, ? extends List<String>>)keyPathInfo);
    }

    @Override
    public void delete() {
        if (this.isFrozen()) {
            throw new IllegalArgumentException("Frozen objects cannot be deleted. They must be converted to live objects first by using `MutableRealm/DynamicMutableRealm.findLatest(frozenObject)`.");
        }
        if (!this.isValid()) {
            throw new IllegalArgumentException(INVALID_OBJECT_MSG);
        }
        NativePointer<RealmObjectT> it = this.getObjectPointer();
        boolean bl = false;
        RealmInterop.INSTANCE.realm_object_delete(it);
    }

    @Override
    public boolean isValid() {
        NativePointer<RealmObjectT> ptr = this.getObjectPointer();
        boolean bl = false;
        return !ptr.isReleased() && RealmInterop.INSTANCE.realm_object_is_valid(ptr);
    }

    public final void checkValid$io_realm_kotlin_library() {
        if (!this.isValid()) {
            throw new IllegalStateException(INVALID_OBJECT_MSG);
        }
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @Override
    @NotNull
    public Notifiable<RealmObjectReference<T>, ObjectChange<T>> notifiable() {
        return CoreNotifiable.DefaultImpls.notifiable(this);
    }

    @Override
    @Nullable
    public CoreNotifiable<RealmObjectReference<T>, ObjectChange<T>> coreObservable(@NotNull LiveRealm liveRealm) {
        return CoreNotifiable.DefaultImpls.coreObservable(this, liveRealm);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/realm/kotlin/internal/RealmObjectReference$Companion;", "", "<init>", "()V", "INVALID_OBJECT_MSG", "", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

