/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.Deleteable;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.UpdatePolicy;
import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.InternalDeleteableKt;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmUtilsKt;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.schema.RealmClass;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.RealmObject;
import io.realm.kotlin.types.TypedRealmObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J!\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\u000b*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lio/realm/kotlin/internal/InternalMutableRealm;", "Lio/realm/kotlin/MutableRealm;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "getConfiguration", "()Lio/realm/kotlin/internal/InternalConfiguration;", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "findLatest", "T", "Lio/realm/kotlin/types/BaseRealmObject;", "obj", "(Lio/realm/kotlin/types/BaseRealmObject;)Lio/realm/kotlin/types/BaseRealmObject;", "copyToRealm", "Lio/realm/kotlin/types/RealmObject;", "instance", "updatePolicy", "Lio/realm/kotlin/UpdatePolicy;", "(Lio/realm/kotlin/types/RealmObject;Lio/realm/kotlin/UpdatePolicy;)Lio/realm/kotlin/types/RealmObject;", "delete", "", "deleteable", "Lio/realm/kotlin/Deleteable;", "Lio/realm/kotlin/types/TypedRealmObject;", "schemaClass", "Lkotlin/reflect/KClass;", "deleteAll", "io.realm.kotlin.library"})
public interface InternalMutableRealm
extends MutableRealm {
    @Override
    @NotNull
    public InternalConfiguration getConfiguration();

    @NotNull
    public LiveRealmReference getRealmReference();

    @Override
    @Nullable
    public <T extends BaseRealmObject> T findLatest(@NotNull T var1);

    @Override
    @NotNull
    public <T extends RealmObject> T copyToRealm(@NotNull T var1, @NotNull UpdatePolicy var2);

    @Override
    public void delete(@NotNull Deleteable var1);

    @Override
    public <T extends TypedRealmObject> void delete(@NotNull KClass<T> var1);

    @Override
    public void deleteAll();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nInternalMutableRealm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalMutableRealm.kt\nio/realm/kotlin/internal/InternalMutableRealm$DefaultImpls\n+ 2 RealmObjectUtil.kt\nio/realm/kotlin/internal/RealmObjectUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n137#2:87\n1863#3,2:88\n*S KotlinDebug\n*F\n+ 1 InternalMutableRealm.kt\nio/realm/kotlin/internal/InternalMutableRealm$DefaultImpls\n*L\n36#1:87\n76#1:88,2\n*E\n"})
    public static final class DefaultImpls {
        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static <T extends BaseRealmObject> T findLatest(@NotNull InternalMutableRealm $this, @NotNull T obj) {
            Object v2;
            Object v0;
            block5: {
                Intrinsics.checkNotNullParameter(obj, (String)"obj");
                if (!BaseRealmObjectExtKt.isValid(obj)) {
                    v0 = null;
                    return v0;
                }
                T $this$runIfManaged$iv = obj;
                boolean $i$f$runIfManaged = false;
                RealmObjectReference<T> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference($this$runIfManaged$iv);
                if (realmObjectReference != null) {
                    RealmObjectReference<T> $this$findLatest_u24lambda_u240 = realmObjectReference;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)$this$findLatest_u24lambda_u240.getOwner(), (Object)$this.getRealmReference())) {
                        v2 = obj;
                        break block5;
                    } else {
                        Object t;
                        CoreNotifiable coreNotifiable = $this$findLatest_u24lambda_u240.thaw($this.getRealmReference());
                        if (coreNotifiable != null) {
                            t = RealmObjectUtilKt.toRealmObject(coreNotifiable);
                            return t;
                        }
                        t = null;
                        return t;
                    }
                }
                v2 = null;
            }
            v0 = v2;
            if (v2 != null) return v0;
            throw new IllegalArgumentException("Unmanaged objects must be part of the Realm, before they can be queried this way. Use `MutableRealm.copyToRealm()` to turn it into a managed object.");
        }

        @NotNull
        public static <T extends RealmObject> T copyToRealm(@NotNull InternalMutableRealm $this, @NotNull T instance, @NotNull UpdatePolicy updatePolicy) {
            Intrinsics.checkNotNullParameter(instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
            return (T)((RealmObject)RealmUtilsKt.copyToRealm$default($this.getConfiguration().getMediator(), $this.getRealmReference(), instance, updatePolicy, null, 16, null));
        }

        public static void delete(@NotNull InternalMutableRealm $this, @NotNull Deleteable deleteable) {
            Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
            InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
        }

        public static <T extends TypedRealmObject> void delete(@NotNull InternalMutableRealm $this, @NotNull KClass<T> schemaClass) {
            Intrinsics.checkNotNullParameter(schemaClass, (String)"schemaClass");
            try {
                $this.delete(TypedRealm.DefaultImpls.query$default($this, schemaClass, null, new Object[0], 2, null).find());
            }
            catch (IllegalStateException err) {
                String string = err.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"not part of this configuration schema", (boolean)false, (int)2, null) : false;
                if (bl) {
                    throw new IllegalArgumentException(err.getMessage());
                }
                throw err;
            }
        }

        public static void deleteAll(@NotNull InternalMutableRealm $this) {
            Iterable $this$forEach$iv = $this.schema().getClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass<? extends TypedRealmObject> clazz;
                RealmClass it = (RealmClass)element$iv;
                boolean bl = false;
                ClassMetadata classMetadata = $this.getRealmReference().getSchemaMetadata().get(it.getName());
                Object object = clazz = classMetadata != null ? classMetadata.getClazz() : null;
                if (clazz != null) {
                    $this.delete(clazz);
                    continue;
                }
                throw new IllegalStateException("Could not delete: " + it.getName());
            }
        }
    }
}

