/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import android.os.Build;
import io.realm.kotlin.internal.RealmInitializer;
import io.realm.kotlin.internal.RealmInstantImpl;
import io.realm.kotlin.internal.platform.LogCatLogger;
import io.realm.kotlin.internal.util.Exceptions;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.types.RealmInstant;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0006\u0010\r\u001a\u00020\u000e\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"OS_NAME", "", "getOS_NAME$annotations", "()V", "getOS_NAME", "()Ljava/lang/String;", "appFilesDirectory", "assetFileAsStream", "Ljava/io/InputStream;", "assetFilename", "createDefaultSystemLogger", "Lio/realm/kotlin/log/RealmLogger;", "tag", "currentTime", "Lio/realm/kotlin/types/RealmInstant;", "io.realm.kotlin.library"})
public final class SystemUtilsAndroidKt {
    @NotNull
    private static final String OS_NAME = "Android";

    @NotNull
    public static final String getOS_NAME() {
        return OS_NAME;
    }

    public static /* synthetic */ void getOS_NAME$annotations() {
    }

    @NotNull
    public static final String appFilesDirectory() {
        String string = RealmInitializer.Companion.getFilesDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    public static final InputStream assetFileAsStream(@NotNull String assetFilename) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)assetFilename, (String)"assetFilename");
        try {
            inputStream = RealmInitializer.Companion.asset(assetFilename);
        }
        catch (FileNotFoundException e) {
            throw Exceptions.INSTANCE.assetFileNotFound(assetFilename, e);
        }
        return inputStream;
    }

    @NotNull
    public static final RealmLogger createDefaultSystemLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new LogCatLogger(tag);
    }

    @NotNull
    public static final RealmInstant currentTime() {
        RealmInstant realmInstant;
        if (Build.VERSION.SDK_INT >= 26) {
            Instant jtInstant = Clock.systemUTC().instant();
            realmInstant = new RealmInstantImpl(jtInstant.getEpochSecond(), jtInstant.getNano());
        } else {
            realmInstant = new RealmInstantImpl(System.currentTimeMillis(), 0);
        }
        return realmInstant;
    }
}

