/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsFalse$;
import spray.json.JsNull$;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsString$;
import spray.json.JsTrue$;
import spray.json.JsValue;
import spray.json.JsonParser$;
import spray.json.ParserInput;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!B\u0001\u0003\u0011\u00039\u0011A\u0003&t_:\u0004\u0016M]:fe*\u00111\u0001B\u0001\u0005UN|gNC\u0001\u0006\u0003\u0015\u0019\bO]1z\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011!BS:p]B\u000b'o]3s'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQAF\u0005\u0005\u0002]\tQ!\u00199qYf$\"\u0001G\u000e\u0011\u0005!I\u0012B\u0001\u000e\u0003\u0005\u001dQ5OV1mk\u0016DQ\u0001H\u000bA\u0002u\tQ!\u001b8qkR\u0004\"\u0001\u0003\u0010\n\u0005}\u0011!a\u0003)beN,'/\u00138qkR4A!I\u0005\u0001E\t\u0001\u0002+\u0019:tS:<W\t_2faRLwN\\\n\u0003A\r\u0002\"\u0001\n\u0017\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002,\u001d\u00059\u0001/Y2lC\u001e,\u0017BA\u0017/\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gN\u0003\u0002,\u001d!A\u0001\u0007\tBC\u0002\u0013\u0005\u0011'A\u0004tk6l\u0017M]=\u0016\u0003I\u0002\"aM\u001c\u000f\u0005Q*\u0004C\u0001\u0014\u000f\u0013\t1d\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c\u000f\u0011!Y\u0004E!A!\u0002\u0013\u0011\u0014\u0001C:v[6\f'/\u001f\u0011\t\u0011u\u0002#Q1A\u0005\u0002E\na\u0001Z3uC&d\u0007\u0002C !\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u000f\u0011,G/Y5mA!)1\u0003\tC\u0001\u0003R\u0019!\tR#\u0011\u0005\r\u0003S\"A\u0005\t\u000bA\u0002\u0005\u0019\u0001\u001a\t\u000fu\u0002\u0005\u0013!a\u0001e\u001d9q)CA\u0001\u0012\u0003A\u0015\u0001\u0005)beNLgnZ#yG\u0016\u0004H/[8o!\t\u0019\u0015JB\u0004\"\u0013\u0005\u0005\t\u0012\u0001&\u0014\u0007%c1\n\u0005\u0002\u000e\u0019&\u0011QJ\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006'%#\ta\u0014\u000b\u0002\u0011\"9\u0011+SI\u0001\n\u0003\u0011\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001TU\t\u0011DkK\u0001V!\t16,D\u0001X\u0015\tA\u0016,A\u0005v]\u000eDWmY6fI*\u0011!LD\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001/X\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b=&\u000b\t\u0011\"\u0003`\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\t1\fgn\u001a\u0006\u0002K\u0006!!.\u0019<b\u0013\t9'M\u0001\u0004PE*,7\r\u001e\u0004\u0005\u0015\t\u0001\u0011n\u0005\u0002i\u0019!AA\u0004\u001bB\u0001B\u0003%Q\u0004C\u0003\u0014Q\u0012\u0005A\u000e\u0006\u0002n]B\u0011\u0001\u0002\u001b\u0005\u00069-\u0004\r!\b\u0005\u0007a\"\u0004\u000b\u0011B9\u0002\u0005M\u0014\u0007CA1s\u0013\t\u0019(MA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\u0007k\"\u0004\u000b\u0015\u0002<\u0002\u0015\r,(o]8s\u0007\"\f'\u000f\u0005\u0002\u000eo&\u0011\u0001P\u0004\u0002\u0005\u0007\"\f'\u000fC\u0005{Q\u0002\u0007\t\u0011)Q\u00051\u00059!n\u001d,bYV,\u0007\"\u0002?i\t\u0003i\u0018\u0001\u00049beN,'j\u001d,bYV,G#\u0001\r\t\u000bqDG\u0011A@\u0015\u0007a\t\t\u0001C\u0004\u0002\u0004y\u0004\r!!\u0002\u0002%\u0005dGn\\<Ue\u0006LG.\u001b8h\u0013:\u0004X\u000f\u001e\t\u0004\u001b\u0005\u001d\u0011bAA\u0005\u001d\t9!i\\8mK\u0006t\u0007\"CA\u0007Q\n\u0007IQBA\b\u0003\r)u*S\u000b\u0003\u0003#y!!a\u0005\u001d\u0007\u0001y\u0000 \u0003\u0005\u0002\u0018!\u0004\u000bQBA\t\u0003\u0011)u*\u0013\u0011\t\u000f\u0005m\u0001\u000e\"\u0003\u0002\u001e\u0005)a/\u00197vKR\u0011\u0011q\u0004\t\u0004\u001b\u0005\u0005\u0012bAA\u0012\u001d\t!QK\\5u\u0011\u001d\t9\u0003\u001bC\u0005\u0003S\tQAZ1mg\u0016$\"!!\u0002\t\u000f\u00055\u0002\u000e\"\u0003\u0002*\u0005!a.\u001e7m\u0011\u001d\t\t\u0004\u001bC\u0005\u0003S\tA\u0001\u001e:vK\"9\u0011Q\u00075\u0005\n\u0005u\u0011AB8cU\u0016\u001cG\u000fC\u0004\u0002:!$I!!\b\u0002\u000b\u0005\u0014(/Y=\t\u000f\u0005u\u0002\u000e\"\u0003\u0002\u001e\u00051a.^7cKJDq!!\u0011i\t\u0013\ti\"A\u0002j]RDq!!\u0012i\t\u0013\ti\"\u0001\u0003ge\u0006\u001c\u0007bBA%Q\u0012%\u0011QD\u0001\u0004Kb\u0004\bbBA'Q\u0012%\u0011QD\u0001\u0010_:,wJ]'pe\u0016$\u0015nZ5ug\"9\u0011\u0011\u000b5\u0005\n\u0005u\u0011\u0001\u0005>fe>|%/T8sK\u0012Kw-\u001b;tQ\u0011\ty%!\u0016\u0011\t\u0005]\u0013\u0011L\u0007\u00023&\u0019\u00111L-\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9\u0011q\f5\u0005\n\u0005%\u0012!\u0002#J\u000f&#\u0006bBA2Q\u0012%\u0011QD\u0001\u0007gR\u0014\u0018N\\4\t\u000f\u0005\u001d\u0004\u000e\"\u0003\u0002*\u0005!1\r[1s\u0011\u001d\tY\u0007\u001bC\u0005\u0003S\tq!Z:dCB,G\rC\u0004\u0002p!$I!!\b\u0002\u0005]\u001c\b\u0006BA7\u0003+Bq!!\u001ei\t\u0013\t9(\u0001\u0002dQR!\u0011QAA=\u0011\u001d\tY(a\u001dA\u0002Y\f\u0011a\u0019\u0005\b\u0003_BG\u0011BA@)\u0011\t)!!!\t\u000f\u0005m\u0014Q\u0010a\u0001m\"9\u0011Q\u00115\u0005\n\u0005%\u0012aB1em\u0006t7-\u001a\u0005\b\u0003\u0013CG\u0011BAF\u0003!\t\u0007\u000f]3oIN\u0013E\u0003BA\u0003\u0003\u001bCq!a\u001f\u0002\b\u0002\u0007a\u000fC\u0004\u0002\u0012\"$I!a%\u0002\u000fI,\u0017/^5sKR!\u0011qDAK\u0011\u001d\tY(a$A\u0002YDq!!'i\t\u0013\tY*\u0001\u0003gC&dG\u0003CAO\u0003G\u000b9+!-\u0011\u00075\ty*C\u0002\u0002\":\u0011qAT8uQ&tw\rC\u0004\u0002&\u0006]\u0005\u0019\u0001\u001a\u0002\rQ\f'oZ3u\u0011)\tI+a&\u0011\u0002\u0003\u0007\u00111V\u0001\u0007GV\u00148o\u001c:\u0011\u00075\ti+C\u0002\u00020:\u00111!\u00138u\u0011%\t\u0019,a&\u0011\u0002\u0003\u0007a/A\u0005feJ|'o\u00115be\"I\u0011q\u00175\u0012\u0002\u0013%\u0011\u0011X\u0001\u000fM\u0006LG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tYLK\u0002\u0002,RC\u0011\"a0i#\u0003%I!!1\u0002\u001d\u0019\f\u0017\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0019\u0016\u0003mR\u0003")
public class JsonParser {
    private final ParserInput input;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        return this.parseJsValue(false);
    }

    public JsValue parseJsValue(boolean allowTrailingInput) {
        block0: {
            this.ws();
            this.value();
            if (allowTrailingInput) break block0;
            this.require('\uffff');
        }
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value() {
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(this.false(), JsFalse$.MODULE$, mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), JsTrue$.MODULE$, mark);
                break;
            }
            case '{': {
                this.advance();
                this.object();
                break;
            }
            case '[': {
                this.advance();
                this.array();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : new JsString(this.sb.toString());
                break;
            }
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private void object() {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = Predef$.MODULE$.Map().empty();
            map = this.members$1(map);
            this.require('}');
            jsObject = new JsObject((Map<String, JsValue>)map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.empty();
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array() {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            Builder list = package$.MODULE$.Vector().newBuilder();
            this.values$1(list);
            this.require(']');
            jsArray = new JsArray((Vector<JsValue>)((Vector)list.result()));
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.empty();
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        this.frac();
        this.exp();
        this.jsValue = startChar == '0' && this.input.cursor() - start == 1 ? JsNumber$.MODULE$.zero() : JsNumber$.MODULE$.apply(this.input.sliceCharArray(start, this.input.cursor()));
        this.ws();
    }

    private void int() {
        block0: {
            if (this.ch('0')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void frac() {
        block0: {
            if (!this.ch('.')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void exp() {
        block0: {
            if (!this.ch('e') && !this.ch('E')) break block0;
            boolean bl = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
        }
    }

    private void oneOrMoreDigits() {
        if (!this.DIGIT()) {
            throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
        }
        this.zeroOrMoreDigits();
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        String string;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError((Object)line);
        }
        int lineNr = line.lineNr();
        int col = line.column();
        String text = line.text();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
        Tuple3 tuple32 = tuple3;
        int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int col2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        String text2 = (String)tuple32._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : ((Object)BoxesRunTime.boxToCharacter((char)errorChar)).toString();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"character '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c2}));
        } else {
            string = "end-of-input";
        }
        String unexpected = string;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ", " at input index ", " (line ", ", position ", "), expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpected, BoxesRunTime.boxToInteger((int)cursor), BoxesRunTime.boxToInteger((int)lineNr2), BoxesRunTime.boxToInteger((int)col2), expected}));
        String sanitizedText = (String)new StringOps(Predef$.MODULE$.augmentString(text2)).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)JsonParser.$anonfun$fail$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom());
        String detail = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", "\\n", "^\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sanitizedText, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(col2 - 1)}));
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (!matched) {
            throw this.fail("JSON Value", mark$1, this.fail$default$3());
        }
        this.jsValue = value;
    }

    private final Map members$1(Map map) {
        Map nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value();
            nextMap = map.updated((Object)key, (Object)this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(Builder list$1) {
        do {
            this.value();
            list$1.$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private final int hexValue$1(char c) {
        int n;
        if ('0' <= c && c <= '9') {
            n = c - 48;
        } else if ('a' <= c && c <= 'f') {
            n = c - 87;
        } else if ('A' <= c && c <= 'F') {
            n = c - 55;
        } else {
            throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
        }
        return n;
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public static final /* synthetic */ char $anonfun$fail$1(char c) {
        return Character.isISOControl(c) ? (char)'?' : (char)c;
    }

    public JsonParser(ParserInput input) {
        this.input = input;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : summary + ":" + detail));
        }
    }
}

