/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.report;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.report.DependencyManagementReportRenderer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.TaskAction;

public class DependencyManagementReportTask
extends DefaultTask {
    private DependencyManagementContainer dependencyManagementContainer;
    private DependencyManagementReportRenderer renderer = new DependencyManagementReportRenderer();
    private final String projectPath;
    private final String projectDescription;
    private final boolean rootProject;
    private final ConfigurationContainer configurationContainer;

    public DependencyManagementReportTask() {
        Project project = this.getProject();
        this.projectPath = project.getPath();
        this.projectDescription = project.getDescription();
        this.rootProject = project.getRootProject().equals(project);
        this.configurationContainer = project.getConfigurations();
    }

    void setRenderer(DependencyManagementReportRenderer renderer) {
        this.renderer = renderer;
    }

    public void setDependencyManagementContainer(DependencyManagementContainer dependencyManagementContainer) {
        this.dependencyManagementContainer = dependencyManagementContainer;
    }

    @TaskAction
    public void report() {
        this.renderer.startProject(this.projectPath, this.projectDescription, this.rootProject);
        Map<String, String> globalManagedVersions = this.dependencyManagementContainer.getManagedVersionsForConfiguration(null);
        this.renderer.renderGlobalManagedVersions(globalManagedVersions);
        TreeSet<Configuration> configurations = new TreeSet<Configuration>(Comparator.comparing(Configuration::getName));
        configurations.addAll((Collection<Configuration>)this.configurationContainer);
        for (Configuration configuration : configurations) {
            Map<String, String> managedVersions = this.dependencyManagementContainer.getManagedVersionsForConfiguration(configuration);
            this.renderer.renderConfigurationManagedVersions(managedVersions, configuration, globalManagedVersions);
        }
    }
}

