/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.gradle;

import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleSettingsWriter;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

class SettingsGradleProjectContributor
implements ProjectContributor {
    private final GradleBuild build;
    private final IndentingWriterFactory indentingWriterFactory;
    private final GradleSettingsWriter settingsWriter;
    private final String settingsFileName;

    SettingsGradleProjectContributor(GradleBuild build, IndentingWriterFactory indentingWriterFactory, GradleSettingsWriter settingsWriter, String settingsFileName) {
        this.build = build;
        this.indentingWriterFactory = indentingWriterFactory;
        this.settingsWriter = settingsWriter;
        this.settingsFileName = settingsFileName;
    }

    public void contribute(Path projectRoot) throws IOException {
        Path settingsGradle = Files.createFile(projectRoot.resolve(this.settingsFileName), new FileAttribute[0]);
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("gradle", (Writer)Files.newBufferedWriter(settingsGradle, new OpenOption[0]));){
            this.settingsWriter.writeTo(writer, this.build);
        }
    }
}

