/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionRange;

class KotlinMavenBuildCustomizer
implements BuildCustomizer<MavenBuild> {
    private static final VersionRange KOTLIN_ONE_EIGHT_OR_LATER = new VersionRange(Version.parse((String)"1.8.0"));
    private final KotlinProjectSettings settings;

    KotlinMavenBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
        this.settings = kotlinProjectSettings;
    }

    @Override
    public void customize(MavenBuild build) {
        build.properties().version("kotlin.version", this.settings.getVersion());
        build.settings().sourceDirectory("${project.basedir}/src/main/kotlin").testSourceDirectory("${project.basedir}/src/test/kotlin");
        build.plugins().add("org.jetbrains.kotlin", "kotlin-maven-plugin", kotlinMavenPlugin -> {
            kotlinMavenPlugin.configuration(configuration -> {
                configuration.configure("args", args -> this.settings.getCompilerArgs().forEach(arg -> args.add("arg", arg)));
                configuration.configure("compilerPlugins", compilerPlugins -> compilerPlugins.add("plugin", "spring"));
            });
            kotlinMavenPlugin.dependency("org.jetbrains.kotlin", "kotlin-maven-allopen", "${kotlin.version}");
        });
        String artifactId = KOTLIN_ONE_EIGHT_OR_LATER.match(Version.parse((String)this.settings.getVersion())) ? "kotlin-stdlib" : "kotlin-stdlib-jdk8";
        build.dependencies().add("kotlin-stdlib", Dependency.withCoordinates((String)"org.jetbrains.kotlin", (String)artifactId).scope(DependencyScope.COMPILE));
    }
}

