/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.condition.ConditionalOnPlatformVersion;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.kotlin.KotlinCompilationUnit;
import io.spring.initializr.generator.language.kotlin.KotlinFunctionDeclaration;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import io.spring.initializr.generator.language.kotlin.KotlinTypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.MainCompilationUnitCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinDependenciesConfigurer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinJpaGradleBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinJpaMavenBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinMavenBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import io.spring.initializr.metadata.InitializrMetadata;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class KotlinProjectGenerationDefaultContributorsConfiguration {
    KotlinProjectGenerationDefaultContributorsConfiguration() {
    }

    @Bean
    TestApplicationTypeCustomizer<KotlinTypeDeclaration> junitJupiterTestMethodContributor() {
        return typeDeclaration -> {
            KotlinFunctionDeclaration function = KotlinFunctionDeclaration.function((String)"contextLoads").body(CodeBlock.of((String)"", (Object[])new Object[0]));
            function.annotations().add(ClassName.of((String)"org.junit.jupiter.api.Test"));
            typeDeclaration.addFunctionDeclaration(function);
        };
    }

    @Bean
    BuildCustomizer<Build> kotlinDependenciesConfigurer() {
        return new KotlinDependenciesConfigurer();
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle")
    KotlinJpaGradleBuildCustomizer kotlinJpaGradleBuildCustomizer(InitializrMetadata metadata, KotlinProjectSettings settings, ProjectDescription projectDescription) {
        return new KotlinJpaGradleBuildCustomizer(metadata, settings, projectDescription);
    }

    @Bean
    @ConditionalOnBuildSystem(value="maven")
    KotlinJpaMavenBuildCustomizer kotlinJpaMavenBuildCustomizer(InitializrMetadata metadata, ProjectDescription projectDescription) {
        return new KotlinJpaMavenBuildCustomizer(metadata, projectDescription);
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle", dialect="kotlin")
    KotlinGradleBuildCustomizer kotlinBuildCustomizerKotlinDsl(KotlinProjectSettings kotlinProjectSettings) {
        return new KotlinGradleBuildCustomizer(kotlinProjectSettings, '\"');
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle", dialect="groovy")
    KotlinGradleBuildCustomizer kotlinBuildCustomizerGroovyDsl(KotlinProjectSettings kotlinProjectSettings) {
        return new KotlinGradleBuildCustomizer(kotlinProjectSettings, '\'');
    }

    @Configuration
    @ConditionalOnPackaging(value="war")
    static class WarPackagingConfiguration {
        WarPackagingConfiguration() {
        }

        @Bean
        ServletInitializerCustomizer<KotlinTypeDeclaration> javaServletInitializerCustomizer(ProjectDescription description) {
            return typeDeclaration -> {
                KotlinFunctionDeclaration configure = KotlinFunctionDeclaration.function((String)"configure").modifiers(new KotlinModifier[]{KotlinModifier.OVERRIDE}).returning("org.springframework.boot.builder.SpringApplicationBuilder").parameters(new Parameter[]{Parameter.of((String)"application", (String)"org.springframework.boot.builder.SpringApplicationBuilder")}).body(CodeBlock.ofStatement((String)"return application.sources($L::class.java)", (Object[])new Object[]{description.getApplicationName()}));
                typeDeclaration.addFunctionDeclaration(configure);
            };
        }
    }

    @Configuration
    @ConditionalOnPlatformVersion(value={"2.0.0.M1"})
    static class SpringBoot2AndLaterKotlinProjectGenerationConfiguration {
        SpringBoot2AndLaterKotlinProjectGenerationConfiguration() {
        }

        @Bean
        @ConditionalOnBuildSystem(value="maven")
        KotlinMavenBuildCustomizer kotlinBuildCustomizer(KotlinProjectSettings kotlinProjectSettings) {
            return new KotlinMavenBuildCustomizer(kotlinProjectSettings);
        }

        @Bean
        MainCompilationUnitCustomizer<KotlinTypeDeclaration, KotlinCompilationUnit> mainFunctionContributor(ProjectDescription description) {
            return compilationUnit -> compilationUnit.addTopLevelFunction(KotlinFunctionDeclaration.function((String)"main").parameters(new Parameter[]{Parameter.of((String)"args", (String)"Array<String>")}).body(CodeBlock.ofStatement((String)"$T<$L>(*args)", (Object[])new Object[]{"org.springframework.boot.runApplication", description.getApplicationName()})));
        }
    }
}

