/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.container.docker.compose;

import io.spring.initializr.generator.container.docker.compose.ComposeFile;
import io.spring.initializr.generator.container.docker.compose.ComposeService;
import io.spring.initializr.generator.spring.documentation.HelpDocument;
import io.spring.initializr.generator.spring.documentation.HelpDocumentCustomizer;
import java.util.Comparator;
import java.util.HashMap;

public class ComposeHelpDocumentCustomizer
implements HelpDocumentCustomizer {
    private final ComposeFile composeFile;

    public ComposeHelpDocumentCustomizer(ComposeFile composeFile) {
        this.composeFile = composeFile;
    }

    @Override
    public void customize(HelpDocument document) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (this.composeFile.services().isEmpty()) {
            document.getWarnings().addItem((Object)"No Docker Compose services found. As of now, the application won't start! Please add at least one service to the `compose.yaml` file.");
        } else {
            model.put("services", this.composeFile.services().values().sorted(Comparator.comparing(ComposeService::getName)).toList());
        }
        document.addSection("documentation/docker-compose", model);
    }
}

