/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.container.docker.compose;

import io.spring.initializr.generator.container.docker.compose.ComposeFile;
import io.spring.initializr.generator.container.docker.compose.ComposeFileWriter;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ComposeProjectContributor
implements ProjectContributor {
    private final ComposeFile composeFile;
    private final IndentingWriterFactory indentingWriterFactory;
    private final ComposeFileWriter composeFileWriter;

    public ComposeProjectContributor(ComposeFile composeFile, IndentingWriterFactory indentingWriterFactory) {
        this.composeFile = composeFile;
        this.indentingWriterFactory = indentingWriterFactory;
        this.composeFileWriter = new ComposeFileWriter();
    }

    public void contribute(Path projectRoot) throws IOException {
        Path file = Files.createFile(projectRoot.resolve("compose.yaml"), new FileAttribute[0]);
        this.writeComposeFile(Files.newBufferedWriter(file, new OpenOption[0]));
    }

    void writeComposeFile(Writer out) throws IOException {
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("yaml", out);){
            this.composeFileWriter.writeTo(writer, this.composeFile);
        }
    }
}

