/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.documentation;

import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.spring.documentation.HelpDocument;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class HelpDocumentProjectContributor
implements ProjectContributor {
    private final HelpDocument helpDocument;

    public HelpDocumentProjectContributor(HelpDocument helpDocument) {
        this.helpDocument = helpDocument;
    }

    public void contribute(Path projectRoot) throws IOException {
        if (this.helpDocument.isEmpty()) {
            return;
        }
        Path file = Files.createFile(projectRoot.resolve("HELP.md"), new FileAttribute[0]);
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(file, new OpenOption[0]));){
            this.helpDocument.write(writer);
        }
    }
}

