/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.language.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public abstract class CompilationUnit<T extends TypeDeclaration> {
    private final String packageName;
    private final String name;
    private final List<T> typeDeclarations = new ArrayList<T>();

    public CompilationUnit(String packageName, String name) {
        Assert.hasText((String)packageName, (String)"'packageName' must not be null");
        Assert.hasText((String)name, (String)"'name' must not be null");
        this.packageName = packageName;
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public T createTypeDeclaration(String name) {
        T typeDeclaration = this.doCreateTypeDeclaration(name);
        this.typeDeclarations.add(typeDeclaration);
        return typeDeclaration;
    }

    public List<T> getTypeDeclarations() {
        return Collections.unmodifiableList(this.typeDeclarations);
    }

    protected abstract T doCreateTypeDeclaration(String var1);
}

