/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.project.contributor;

import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class MultipleResourcesProjectContributor
implements ProjectContributor {
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final String rootResource;
    private final Predicate<String> executable;

    public MultipleResourcesProjectContributor(String rootResource) {
        this(rootResource, filename -> false);
    }

    public MultipleResourcesProjectContributor(String rootResource, Predicate<String> executable) {
        this.rootResource = StringUtils.trimTrailingCharacter((String)rootResource, (char)'/');
        this.executable = executable;
    }

    @Override
    public void contribute(Path projectRoot) throws IOException {
        Resource[] resources;
        Resource root = this.resolver.getResource(this.rootResource);
        for (Resource resource : resources = this.resolver.getResources(this.rootResource + "/**")) {
            if (!resource.isReadable()) continue;
            String filename = this.extractFileName(root.getURI(), resource.getURI());
            Path output = projectRoot.resolve(filename);
            if (!Files.exists(output, new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                Files.createFile(output, new FileAttribute[0]);
            }
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)Files.newOutputStream(output, new OpenOption[0]));
            output.toFile().setExecutable(this.executable.test(filename));
        }
    }

    private String extractFileName(URI root, URI resource) {
        String candidate = resource.toString().substring(root.toString().length());
        return StringUtils.trimLeadingCharacter((String)candidate, (char)'/');
    }
}

