/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.support;

import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyMetadata;
import io.spring.initializr.metadata.DependencyMetadataProvider;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.Repository;
import java.util.LinkedHashMap;
import org.springframework.cache.annotation.Cacheable;

public class DefaultDependencyMetadataProvider
implements DependencyMetadataProvider {
    @Cacheable(cacheNames={"initializr.dependency-metadata"}, key="#p1")
    public DependencyMetadata get(InitializrMetadata metadata, Version bootVersion) {
        LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
        for (Object dependency : metadata.getDependencies().getAll()) {
            if (!dependency.match(bootVersion)) continue;
            dependencies.put(dependency.getId(), dependency.resolve(bootVersion));
        }
        LinkedHashMap<String, Repository> repositories = new LinkedHashMap<String, Repository>();
        for (Dependency dependency : dependencies.values()) {
            if (dependency.getRepository() == null) continue;
            repositories.put(dependency.getRepository(), (Repository)metadata.getConfiguration().getEnv().getRepositories().get(dependency.getRepository()));
        }
        LinkedHashMap<String, BillOfMaterials> boms = new LinkedHashMap<String, BillOfMaterials>();
        for (Dependency dependency : dependencies.values()) {
            if (dependency.getBom() == null) continue;
            boms.put(dependency.getBom(), ((BillOfMaterials)metadata.getConfiguration().getEnv().getBoms().get(dependency.getBom())).resolve(bootVersion));
        }
        for (BillOfMaterials bom : boms.values()) {
            for (String id : bom.getRepositories()) {
                repositories.put(id, (Repository)metadata.getConfiguration().getEnv().getRepositories().get(id));
            }
        }
        return new DependencyMetadata(bootVersion, dependencies, repositories, boms);
    }
}

