/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedConstructor;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.members.ResolvedParameterizedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FactoryMethodProvider {
    private MemberResolver memberResolver;

    @Autowired
    public FactoryMethodProvider(TypeResolver resolver) {
        this.memberResolver = new MemberResolver(resolver);
    }

    public Optional<? extends ResolvedParameterizedMember> in(ResolvedType resolvedType, Predicate<ResolvedParameterizedMember> predicate) {
        return Stream.concat(this.constructors(resolvedType).stream(), this.delegatedFactoryMethods(resolvedType).stream()).filter(predicate).findFirst();
    }

    static Predicate<ResolvedParameterizedMember> factoryMethodOf(AnnotatedParameter parameter) {
        return input -> input.getRawMember().equals(parameter.getOwner().getMember());
    }

    public Collection<ResolvedConstructor> constructors(ResolvedType resolvedType) {
        ResolvedTypeWithMembers typeWithMembers = this.memberResolver.resolve(resolvedType, null, null);
        return Stream.of(typeWithMembers.getConstructors()).collect(Collectors.toList());
    }

    public Collection<ResolvedMethod> delegatedFactoryMethods(ResolvedType resolvedType) {
        ResolvedTypeWithMembers typeWithMembers = this.memberResolver.resolve(resolvedType, null, null);
        return Stream.of(typeWithMembers.getStaticMethods()).collect(Collectors.toList());
    }
}

