/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public class CombinedRequestHandler
implements RequestHandler {
    private final RequestHandler first;
    private final RequestHandler second;

    public CombinedRequestHandler(RequestHandler first, RequestHandler second) {
        this.first = first;
        this.second = second;
    }

    public Class<?> declaringClass() {
        return this.first.declaringClass();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.first.isAnnotatedWith(annotation) || this.second.isAnnotatedWith(annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.first.getPatternsCondition().combine(this.second.getPatternsCondition());
    }

    public String groupName() {
        return this.first.groupName();
    }

    public String getName() {
        return this.first.getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return Stream.concat(this.first.supportedMethods().stream(), this.second.supportedMethods().stream()).collect(Collectors.toSet());
    }

    public Set<MediaType> produces() {
        return Stream.concat(Optional.ofNullable(this.first.produces()).orElse(Collections.emptySet()).stream(), Optional.ofNullable(this.second.produces()).orElse(Collections.emptySet()).stream()).collect(Collectors.toSet());
    }

    public Set<MediaType> consumes() {
        return Stream.concat(Optional.ofNullable(this.first.consumes()).orElse(Collections.emptySet()).stream(), Optional.ofNullable(this.second.consumes()).orElse(Collections.emptySet()).stream()).collect(Collectors.toSet());
    }

    public Set<NameValueExpression<String>> headers() {
        return Stream.concat(this.first.headers().stream(), this.second.headers().stream()).collect(Collectors.toSet());
    }

    public Set<NameValueExpression<String>> params() {
        return this.first.params();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.first.findAnnotation(annotation).map(Optional::of).orElse(this.second.findAnnotation(annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.first.getParameters();
    }

    public ResolvedType getReturnType() {
        return this.first.getReturnType();
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.first.findControllerAnnotation(annotation).map(Optional::of).orElse(this.second.findControllerAnnotation(annotation));
    }

    public RequestMappingInfo<?> getRequestMapping() {
        return this.first.getRequestMapping();
    }

    public HandlerMethod getHandlerMethod() {
        return this.second.getHandlerMethod();
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }

    public String toString() {
        return new StringJoiner(", ", CombinedRequestHandler.class.getSimpleName() + "{", "}").add("first=" + this.first).add("second=" + this.second).add("combined key=" + this.key()).toString();
    }
}

