/*
 *
 *  Copyright 2017-2019 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */
package springfox.documentation.swagger.readers.parameter;


import io.swagger.annotations.ExampleProperty;
import springfox.documentation.schema.Example;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import static java.util.Optional.*;
import static org.springframework.util.StringUtils.*;

public class Examples {
  private Examples() {
    throw new UnsupportedOperationException();
  }

  public static Map<String, List<Example>> examples(io.swagger.annotations.Example example) {
    Map<String, List<Example>> examples = new HashMap<>();
    for (ExampleProperty each : example.value()) {
      if (!isEmpty(each.value())) {
        examples.putIfAbsent(each.mediaType(), new LinkedList<>());
        examples.get(each.mediaType()).add(new Example(ofNullable(each.mediaType())
            .filter(((Predicate<String>) String::isEmpty).negate())
            .orElse(null), each.value()));
      }
    }
    return examples;
  }
}
