/*
 * Decompiled with CFR 0.152.
 */
package io.starter.OpenXLS;

import io.starter.OpenXLS.CellHandle;
import io.starter.OpenXLS.FormulaHandle;
import io.starter.OpenXLS.WorkBookHandle;
import io.starter.OpenXLS.WorkSheetHandle;
import io.starter.formats.XLS.CellNotFoundException;
import io.starter.formats.XLS.FormulaNotFoundException;
import io.starter.formats.XLS.FunctionNotSupportedException;
import io.starter.formats.XLS.WorkSheetNotFoundException;
import io.starter.toolkit.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class testformula {
    WorkBookHandle book = null;
    WorkSheetHandle sheet = null;
    String sheetname = "Sheet1";
    String wd = System.getProperty("user.dir") + "/docs/samples/Formulas/";
    String finpath = this.wd + "testFormula.xls";
    WorkSheetHandle sht = null;

    testformula() {
    }

    public void testMultiChange() {
        try {
            Logger.logInfo((String)"Testing multiple changes to formula references and recalc");
            WorkBookHandle wbx = new WorkBookHandle();
            WorkSheetHandle sheet1 = wbx.getWorkSheet(0);
            sheet1.add((Object)new Double(100.123), "A1");
            sheet1.add((Object)new Double(200.123), "A2");
            CellHandle cx = sheet1.add((Object)"=sum(A1*A2)", "A3");
            Logger.logInfo((String)String.valueOf(cx));
            Logger.logInfo((String)"start setting 100k vals");
            for (int t = 0; t < 100000; ++t) {
                sheet1.getCell("A1").setVal(Math.random() * 10000.0);
                sheet1.getCell("A2").setVal(Math.random() * 10000.0);
                Object calced = cx.getVal();
                Logger.logInfo((String)calced.toString());
            }
            Logger.logInfo((String)"done setting 100k vals");
            wbx.write((OutputStream)new FileOutputStream(new File(this.wd + "testFormulas_out.xls")), 100);
        }
        catch (Exception ex) {
            Logger.logErr((String)("testFormulas.testMultiChange: " + ex.toString()));
        }
    }

    public void testCalculation() {
        try {
            this.openSheet(this.finpath, this.sheetname);
            CellHandle mycell1 = this.sheet.getCell("C4");
            CellHandle mycell2 = this.sheet.getCell("D4");
            CellHandle myformulacell = this.sheet.getCell("F4");
            FormulaHandle form = myformulacell.getFormulaHandle();
            Logger.log((String)form.calculate().toString());
            mycell1.setVal(99);
            mycell2.setVal(420);
            Logger.log((String)form.calculate().toString());
            this.testWrite("testCalculation_out.xls");
        }
        catch (CellNotFoundException e) {
            Logger.log((String)("cell not found" + (Object)((Object)e)));
        }
        catch (FormulaNotFoundException e) {
            Logger.log((String)("No formula to change" + (Object)((Object)e)));
        }
        catch (Exception e) {
            Logger.logErr((String)"TestFormulas failed.", (Exception)e);
        }
    }

    public void changeSingleCellLoc() {
        try {
            this.openSheet(this.finpath, this.sheetname);
            CellHandle mycell = this.sheet.getCell("A10");
            FormulaHandle form = mycell.getFormulaHandle();
            form.changeFormulaLocation("A3", "G10");
            this.testWrite("testChangeSingleCellLoc_out.xls");
        }
        catch (CellNotFoundException e) {
            Logger.log((String)("cell not found" + (Object)((Object)e)));
        }
        catch (FormulaNotFoundException e) {
            Logger.log((String)("No formula to change" + (Object)((Object)e)));
        }
    }

    public void testHandlerFunctions() {
        try {
            this.openSheet(this.finpath, this.sheetname);
            CellHandle mycell = this.sheet.getCell("E8");
            FormulaHandle myhandle = mycell.getFormulaHandle();
            boolean b = myhandle.changeFormulaLocation("A1:B2", "D1:D28");
            this.testWrite("testHandlerFunctions_out.xls");
        }
        catch (CellNotFoundException e) {
            Logger.log((String)("cell not found" + (Object)((Object)e)));
        }
        catch (FormulaNotFoundException e) {
            Logger.log((String)("No formula to change" + (Object)((Object)e)));
        }
    }

    public void testCellHandlerFunctions() {
        try {
            this.openSheet(this.finpath, this.sheetname);
            CellHandle mycell = this.sheet.getCell("E8");
            CellHandle secondcell = this.sheet.getCell("D19");
            FormulaHandle myhandle = mycell.getFormulaHandle();
            boolean b = myhandle.addCellToRange("A1:B2", secondcell);
            this.testWrite("testCellHandlerFunctions_out.xls");
        }
        catch (CellNotFoundException e) {
            Logger.log((String)("cell not found" + (Object)((Object)e)));
        }
        catch (FormulaNotFoundException e) {
            Logger.log((String)("No formula to change" + (Object)((Object)e)));
        }
    }

    public void testFormula() {
        try {
            String finpath = this.wd + "testFormula.xls";
            String sheetname = "Sheet1";
            this.openSheet(finpath, sheetname);
            this.sheet.removeRow(2, true);
            this.testWrite("testFormula_out.xls");
        }
        catch (Exception e) {
            Logger.log((String)("Exception in testFORMULA.testFormulaSeries(): " + e));
        }
    }

    void testFormulaCalc(String fs, String sh) {
        WorkBookHandle book = new WorkBookHandle(fs);
        this.sheetname = sh;
        try {
            this.sht = book.getWorkSheet(this.sheetname);
        }
        catch (Exception e) {
            Logger.logErr((String)"TestFormulas failed.", (Exception)e);
        }
        FormulaHandle f = null;
        Double i = null;
        if (this.sheetname.equalsIgnoreCase("Sheet1")) {
            try {
                this.sht.add(null, "A1");
                CellHandle c = this.sht.getCell("A1");
                c.setFormula("b1+5");
                f = c.getFormulaHandle();
                i = (Double)f.calculate();
                this.sht.add(null, "A2");
                c = this.sht.getCell("A2");
                c.setFormula("B1+ A1");
                f = c.getFormulaHandle();
                i = (Double)f.calculate();
                f.setFormula("B1 - 5");
                i = (Double)f.calculate();
                f.setFormula("D1 * F1");
                i = (Double)f.calculate();
                f.setFormula("E1 / F1");
                i = (Double)f.calculate();
                f.setFormula("E1 ^ F1");
                i = (Double)f.calculate();
                f.setFormula("E1 > F1");
                Boolean b = (Boolean)f.calculate();
                f.setFormula("E1 >= F1");
                b = (Boolean)f.calculate();
                f.setFormula("E1 < F1");
                b = (Boolean)f.calculate();
                f.setFormula("E1 <= F1");
                b = (Boolean)f.calculate();
                f.setFormula("Pi()");
                i = (Double)f.calculate();
                f.setFormula("LOG(10,2)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("ROUND(32.443,1)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("MOD(45,6)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("DATE(1998,2,4)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("SUM(1998,2,4)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("IF(TRUE,1,0)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("ISERR(\"test\")");
                b = (Boolean)f.calculate();
                Logger.log((String)b.toString());
                f.setFormula("SUM(12,3,2,4,5,1)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("IF((1<2),1,0)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("IF((1<2),MOD(45,6),1)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("IF((1<2),if((true),8,1),1)");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
                f.setFormula("IF((SUM(23,2,3,4)<12),if((true),8,1),DATE(1998,2,4))");
                i = (Double)f.calculate();
                Logger.log((String)i.toString());
            }
            catch (CellNotFoundException e) {
                Logger.logErr((String)"TestFormulas failed.", (Exception)((Object)e));
            }
            catch (FunctionNotSupportedException e) {
                Logger.logErr((String)"TestFormulas failed.", (Exception)((Object)e));
            }
            catch (Exception e) {
                Logger.logErr((String)"TestFormulas failed.", (Exception)e);
            }
            this.testWrite("testCalcFormulas_out.xls");
        }
    }

    public void openSheet(String finp, String sheetnm) {
        this.book = new WorkBookHandle(finp);
        try {
            this.sheet = this.book.getWorkSheet(sheetnm);
        }
        catch (WorkSheetNotFoundException e) {
            Logger.log((String)("couldn't find worksheet" + (Object)((Object)e)));
        }
    }

    public void testWrite(String fname) {
        try {
            File f = new File(this.wd + fname);
            FileOutputStream fos = new FileOutputStream(f);
            BufferedOutputStream bbout = new BufferedOutputStream(fos);
            this.book.write((OutputStream)bbout);
            bbout.flush();
            fos.close();
        }
        catch (IOException e) {
            Logger.logInfo((String)("IOException in Tester.  " + e));
        }
    }
}

